package net.glasslauncher.mods.alwaysmoreitems.plugins.ami.description;

import net.glasslauncher.mods.alwaysmoreitems.api.gui.AMIDrawable;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.GuiItemStackGroup;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.RecipeLayout;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeCategory;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeWrapper;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.VanillaRecipeCategoryUid;
import net.glasslauncher.mods.alwaysmoreitems.gui.DrawableHelper;
import net.minecraft.class_300;
import net.minecraft.client.Minecraft;
import javax.annotation.Nonnull;

public class ItemDescriptionRecipeCategory implements RecipeCategory {
    public static final int recipeWidth = 160;
    public static final int recipeHeight = 125;
    @Nonnull
    private final AMIDrawable background;
    @Nonnull
    private final String localizedName;

    public ItemDescriptionRecipeCategory() {
        background = DrawableHelper.createBlankDrawable(recipeWidth, recipeHeight);
        localizedName = class_300.method_992().method_993("gui.alwaysmoreitems.category.itemDescription");
    }

    @Nonnull
    @Override
    public String getUid() {
        return VanillaRecipeCategoryUid.DESCRIPTION;
    }

    @Nonnull
    @Override
    public String getTitle() {
        return localizedName;
    }

    @Nonnull
    @Override
    public AMIDrawable getBackground() {
        return background;
    }

    @Override
    public void drawExtras(Minecraft minecraft) {

    }

    @Override
    public void drawAnimations(Minecraft minecraft) {

    }

    @Override
    public void setRecipe(@Nonnull RecipeLayout recipeLayout, @Nonnull RecipeWrapper recipeWrapper) {
        GuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();

        int xPos = (recipeWidth - 18) / 2;
        guiItemStacks.init(0, false, xPos, 0);
        guiItemStacks.setFromRecipe(0, recipeWrapper.getOutputs());
    }
}
