/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.gui;

import java.awt.Color;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicInteger;
import net.glasslauncher.mods.alwaysmoreitems.api.Rarity;
import net.glasslauncher.mods.alwaysmoreitems.api.RarityProvider;
import net.glasslauncher.mods.alwaysmoreitems.gui.AMIDrawContext;
import net.glasslauncher.mods.alwaysmoreitems.gui.AMITextRenderer;
import net.glasslauncher.mods.alwaysmoreitems.gui.RenderHelper;
import net.glasslauncher.mods.alwaysmoreitems.gui.TooltipEdge;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.ingredients.ItemStackRenderer;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.alwaysmoreitems.util.ImageUtil;
import net.minecraft.class_124;
import net.minecraft.class_136;
import net.minecraft.class_293;
import net.minecraft.class_300;
import net.minecraft.class_31;
import net.minecraft.class_32;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.client.TooltipHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class Tooltip {
    public static final Tooltip INSTANCE = new Tooltip();
    public static final Color DEFAULT_FONT_COLOR = new Color(255, 255, 255, 255);
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(0, 0, 0, 192);
    public static final Dimension DEFAULT_OFFSET = new Dimension(12, -12);
    private static final ItemStackRenderer ITEM_STACK_RENDERER = new ItemStackRenderer();
    @Nullable
    protected String simpleTip;
    @Nullable
    protected class_31 itemStack;
    protected int cursorX;
    protected int cursorY;
    protected Rarity rarity;
    protected int screenWidth;
    protected int screenHeight;
    @Nullable
    protected class_32 screen;
    @Nullable
    protected class_293 containerScreen;
    protected List<Object> tooltip;
    protected int cachedTooltipWidth = 0;

    private Tooltip() {
    }

    public void setTooltip(@NotNull class_31 itemStack, int cursorX, int cursorY) {
        Rarity rarity;
        this.simpleTip = null;
        this.itemStack = itemStack;
        this.tooltip = null;
        this.cursorX = cursorX;
        this.cursorY = cursorY;
        class_124 class_1242 = itemStack.method_694();
        if (class_1242 instanceof RarityProvider) {
            RarityProvider rarityProvider = (RarityProvider)class_1242;
            rarity = rarityProvider.getRarity(itemStack);
        } else {
            rarity = Rarity.VANILLA;
        }
        this.rarity = rarity;
        this.commonInit();
    }

    public void setTooltip(@NotNull List<Object> tooltip, int cursorX, int cursorY, Rarity rarity) {
        this.simpleTip = null;
        this.itemStack = null;
        this.tooltip = tooltip;
        this.cursorX = cursorX;
        this.cursorY = cursorY;
        this.rarity = rarity;
        this.commonInit();
    }

    public void setTooltip(@NotNull List<Object> tooltip, int cursorX, int cursorY) {
        String tooltipString;
        Object object;
        this.simpleTip = null;
        this.itemStack = null;
        this.tooltip = new ArrayList<Object>(tooltip);
        this.cursorX = cursorX;
        this.cursorY = cursorY;
        this.rarity = Rarity.VANILLA;
        if (!tooltip.isEmpty() && (object = tooltip.get(0)) instanceof String && (tooltipString = (String)object).startsWith(String.valueOf('\u00d7'))) {
            this.rarity = Rarity.AMI_RARITIES_BY_CODE.get(Character.valueOf(tooltipString.charAt(1)));
        }
        this.commonInit();
    }

    public void commonInit() {
        class_293 handledScreen;
        this.screen = Minecraft.field_2791.field_2816;
        if (this.screen == null) {
            this.containerScreen = null;
            this.screenHeight = 0;
            this.screenWidth = 0;
            this.setupTooltip();
            this.onScreenIsNull();
            return;
        }
        this.screenWidth = this.screen.field_152;
        this.screenHeight = this.screen.field_153;
        class_32 class_323 = this.screen;
        this.containerScreen = class_323 instanceof class_293 ? (handledScreen = (class_293)class_323) : null;
        this.setupTooltip();
    }

    public void setupTooltip() {
        if (this.itemStack != null) {
            this.simpleTip = class_300.method_992().method_993(this.itemStack.method_726() + ".name");
            this.tooltip = new ArrayList<Object>(TooltipHelper.getTooltipForItemStack((String)this.simpleTip, (class_31)this.itemStack, (class_136)Minecraft.field_2791.field_2806.field_519, (class_293)this.containerScreen));
        }
    }

    public void clear() {
        this.tooltip = null;
        this.cachedTooltipWidth = 0;
    }

    public void render() {
        if (this.isEmpty()) {
            return;
        }
        GL11.glEnable((int)3042);
        Bounds bounds = this.getBounds(false);
        this.renderBackground(bounds, false);
        this.renderHeader();
        int xStart = bounds.x1();
        int yStart = bounds.y1();
        int xPos = xStart + this.getTextXOffset(false);
        int spacing = this.getPadding(TooltipEdge.SPACING);
        int yPos = yStart + this.getPadding(TooltipEdge.TOP);
        for (int i = 0; i < this.tooltip.size() - 1; ++i) {
            Object line = this.tooltip.get(i + 1);
            this.renderLine(line, xPos, yPos, DEFAULT_FONT_COLOR);
            yPos += this.getLineHeight(line) + spacing;
        }
    }

    public int getLineHeight(Object line) {
        if (line instanceof String) {
            return 9;
        }
        if (line instanceof Divider) {
            return 1;
        }
        if (line instanceof class_31) {
            return 16;
        }
        if (line instanceof Image) {
            Image image = (Image)line;
            return image.getHeight();
        }
        return 0;
    }

    public int getLineWidth(Object line) {
        if (line instanceof String) {
            String string = (String)line;
            return AMITextRenderer.INSTANCE.method_1901(string);
        }
        if (line instanceof Divider) {
            return 1;
        }
        if (line instanceof class_31) {
            return 16;
        }
        if (line instanceof Image) {
            Image image = (Image)line;
            try {
                return image.getWidth();
            }
            catch (Exception e) {
                AlwaysMoreItems.LOGGER.error((Object)e);
                return 0;
            }
        }
        return 0;
    }

    public void renderLine(Object line, int x, int y, Color color) {
        if (line instanceof String) {
            String string = (String)line;
            AMITextRenderer.INSTANCE.method_1903(string, x, y, color.getRGB());
        } else if (line instanceof Divider) {
            AMIDrawContext.INSTANCE.method_1932(x, y, x + this.getMaxLineWidth(), y + 1, color.getRGB());
        } else if (line instanceof class_31) {
            class_31 lineStack = (class_31)line;
            RenderHelper.enableItemLighting();
            GL11.glDisable((int)2929);
            ITEM_STACK_RENDERER.draw(Minecraft.field_2791, x, y, lineStack);
            RenderHelper.disableItemLighting();
        } else if (line instanceof Image) {
            Image image = (Image)line;
            image.draw(x, y, this.getMaxLineWidth(), color);
        }
    }

    public void renderHeader() {
        String headerText = (String)this.tooltip.get(0);
        if (headerText == null || headerText.isEmpty()) {
            throw new RuntimeException("Header text is null or empty somehow");
        }
        Bounds bounds = this.getBounds(true);
        this.renderBackground(bounds, true);
        int leftPadding = this.getTextXOffset(true);
        int topPadding = this.getPadding(TooltipEdge.LEFT);
        int xPos = bounds.x1() + leftPadding;
        int yPos = bounds.y1() + topPadding;
        AMITextRenderer.INSTANCE.method_1903(headerText, xPos, yPos, this.rarity.textColor.getRGB());
    }

    public void renderBackground(Bounds bounds, boolean header) {
        AMIDrawContext.INSTANCE.method_1932(bounds.x1(), bounds.y1(), bounds.x2(), bounds.y2(), header ? this.rarity.backgroundColor.getRGB() : DEFAULT_BACKGROUND_COLOR.getRGB());
        if (header) {
            this.drawIcons(bounds);
        }
    }

    public void drawIcons(Bounds bounds) {
        boolean[][] icon = this.rarity.headerCode.icon;
        int templateWidth = icon[0].length;
        ArrayList<Integer> edgesToStretch = new ArrayList<Integer>();
        int x1 = bounds.x1();
        int y1 = bounds.y1();
        int x2 = bounds.x2();
        for (int y = 0; y < icon.length; ++y) {
            for (int x = 0; x < icon[y].length; ++x) {
                if (icon[y][x]) {
                    AMIDrawContext.INSTANCE.method_1932(x1 + x, y1 + y, x1 + x + 1, y1 + y + 1, this.rarity.iconColor.getRGB());
                    if (this.rarity.headerCode.edgesStretchAcross && x == templateWidth - 1) {
                        edgesToStretch.add(y);
                    }
                }
                if (!icon[y][templateWidth - 1 - x]) continue;
                AMIDrawContext.INSTANCE.method_1932(x2 - templateWidth + x, y1 + y, x2 - templateWidth + x + 1, y1 + y + 1, this.rarity.iconColor.getRGB());
            }
        }
        edgesToStretch.forEach(edge -> AMIDrawContext.INSTANCE.method_1932(x1 + templateWidth, y1 + edge, x2 - templateWidth, y1 + 1 + edge, this.rarity.iconColor.getRGB()));
    }

    public Bounds getBounds(boolean header) {
        Dimension offsets = this.getOffset(this.isFlipped());
        int yOffset = 0;
        if (!header) {
            yOffset += this.getHeight(true);
        }
        yOffset += Math.min(0, this.screenHeight - (this.cursorY + offsets.height + this.getHeight(false) + this.getHeight(true)));
        return new Bounds(this.cursorX + offsets.width, this.cursorY + offsets.height + (yOffset += Math.max(0, -(this.cursorY + offsets.height))), this.cursorX + offsets.width + this.getWidth(), this.cursorY + offsets.height + yOffset + this.getHeight(header));
    }

    public int getHeaderHeight() {
        return 9 + this.getPadding(this.rarity.equals((Object)Rarity.VANILLA) ? TooltipEdge.HEADER_VANILLA : TooltipEdge.HEADER_WITH_RARITY);
    }

    public void onScreenIsNull() {
        throw new RuntimeException("Screen is null when it shouldn't be");
    }

    public int getPadding(TooltipEdge edge) {
        return edge.padding;
    }

    public int getTextXOffset(boolean header) {
        if (!header) {
            return this.getPadding(TooltipEdge.LEFT);
        }
        return this.getPadding(TooltipEdge.LEFT) + this.rarity.headerCode.icon[0].length;
    }

    public int getLines(boolean header) {
        int lines = 1;
        if (!header) {
            lines = this.tooltip.size() - 1;
        }
        return lines;
    }

    public int getHeight(boolean header) {
        int lines = this.getLines(header);
        if (header) {
            return this.getHeaderHeight();
        }
        ArrayList<Object> headerlessTip = new ArrayList<Object>(this.tooltip);
        headerlessTip.remove(0);
        AtomicInteger atomicInteger = new AtomicInteger();
        headerlessTip.forEach(entry -> atomicInteger.addAndGet(this.getLineHeight(entry)));
        return this.getPadding(TooltipEdge.TOP) + lines * this.getPadding(TooltipEdge.BOTTOM) + atomicInteger.get();
    }

    public int getWidth() {
        if (this.cachedTooltipWidth != 0) {
            return this.cachedTooltipWidth + this.getPadding(TooltipEdge.LEFT_RIGHT);
        }
        int maxWidth = this.getMaxLineWidth();
        return maxWidth + this.getPadding(TooltipEdge.LEFT_RIGHT);
    }

    public int getMaxLineWidth() {
        if (this.cachedTooltipWidth != 0) {
            return this.cachedTooltipWidth;
        }
        OptionalInt potentialWidth = this.tooltip.stream().mapToInt(this::getLineWidth).max();
        if (potentialWidth.isEmpty()) {
            return 0;
        }
        int headerWidth = AMITextRenderer.INSTANCE.method_1901((String)this.tooltip.get(0)) + this.rarity.headerCode.icon[0].length;
        this.cachedTooltipWidth = Math.max(potentialWidth.getAsInt(), headerWidth);
        return this.cachedTooltipWidth;
    }

    public boolean isFlipped() {
        return this.getOffset((boolean)false).width + this.cursorX + this.getWidth() > this.screenWidth;
    }

    public Dimension getOffset(boolean flipped) {
        if (flipped) {
            return new Dimension(-12 - this.getWidth(), -12);
        }
        return DEFAULT_OFFSET;
    }

    @Nullable
    public class_31 getItemStack() {
        return this.itemStack;
    }

    @Nullable
    public class_293 getContainerScreen() {
        return this.containerScreen;
    }

    public boolean isEmpty() {
        return this.tooltip == null || this.tooltip.isEmpty();
    }

    public record Bounds(int x1, int y1, int x2, int y2) {
    }

    public record Divider() {
        public static final Divider INSTANCE = new Divider();
    }

    public static class Image {
        public final String image;
        private final int width;
        private final int height;

        public Image(String image) {
            this.image = image;
            try {
                Dimension dimension = ImageUtil.getImageDimension(Paths.get(this.getClass().getResource(image).toURI()).toFile());
                this.width = dimension.width;
                this.height = dimension.height;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void draw(int x, int y, int maxTipWidth, Color color) {
            RenderHelper.bindTexture(this.image);
            AMIDrawContext.INSTANCE.method_1936(x, y, 1, 1, this.width, this.height);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    public record Dimension(int width, int height) {
    }
}

