/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.gui.screen;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.AttributeNotFoundException;
import net.glasslauncher.mods.alwaysmoreitems.action.ActionButtonRegistry;
import net.glasslauncher.mods.alwaysmoreitems.api.action.ActionButton;
import net.glasslauncher.mods.alwaysmoreitems.config.AMIConfig;
import net.glasslauncher.mods.alwaysmoreitems.config.OverlayMode;
import net.glasslauncher.mods.alwaysmoreitems.gui.RenderHelper;
import net.glasslauncher.mods.alwaysmoreitems.gui.Tooltip;
import net.glasslauncher.mods.alwaysmoreitems.gui.screen.RecipesGui;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.AMISettingsButton;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.ActionButtonWidget;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.SearchTextFieldWidget;
import net.glasslauncher.mods.alwaysmoreitems.init.KeybindListener;
import net.glasslauncher.mods.alwaysmoreitems.network.c2s.ActionButtonPacket;
import net.glasslauncher.mods.alwaysmoreitems.network.c2s.GiveItemPacket;
import net.glasslauncher.mods.alwaysmoreitems.recipe.Focus;
import net.glasslauncher.mods.alwaysmoreitems.recipe.ItemFilter;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.alwaysmoreitems.util.Commands;
import net.glasslauncher.mods.alwaysmoreitems.util.ItemStackElement;
import net.glasslauncher.mods.gcapi3.api.GCAPI;
import net.glasslauncher.mods.gcapi3.impl.GlassYamlFile;
import net.minecraft.class_133;
import net.minecraft.class_136;
import net.minecraft.class_169;
import net.minecraft.class_264;
import net.minecraft.class_293;
import net.minecraft.class_300;
import net.minecraft.class_31;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_54;
import net.minecraft.class_564;
import net.minecraft.class_8;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.client.TooltipHelper;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.ColorHelper;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class OverlayScreen
extends class_32 {
    public static final OverlayScreen INSTANCE = new OverlayScreen();
    public class_32 parent;
    public final RecipesGui recipesGui = new RecipesGui();
    public SearchTextFieldWidget searchField;
    public static int searchFieldWidth = 160;
    public ActionButtonWidget trashButton;
    ArrayList<ActionButtonWidget> actionButtons;
    public static int maxActionButtonPanelWidth = 100;
    public static int actionButtonOffset = 2;
    public List<String> currentTooltip;
    public static int maxItemListWidth = 200;
    public static int maxItemListHeight = 400;
    public static int itemSize = 18;
    ArrayList<ItemRenderEntry> renderedItems;
    public class_33 nextButton;
    public class_33 previousButton;
    public class_33 settingsButton;
    int currentPage = 0;
    int pageCount = 1;
    boolean rolloverPage = true;
    public boolean flipScrollDirection = false;
    public ItemRenderEntry hoveredItem = null;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private int lastItemWidth = 0;
    private int lastItemHeight = 0;
    private int lastScaledWidth = 0;
    private boolean lastCenteredBar = true;
    private int lastItemListWidth = 0;
    private int lastItemListHeight = 0;
    private int lastParent = 0;
    private OverlayMode lastOverlayMode = OverlayMode.RECIPE;
    int lastMouseX = 0;
    int lastMouseY = 0;
    class_564 screenScaler;
    int id;

    private OverlayScreen() {
    }

    public void init(class_32 parent, int width, int height) {
        this.parent = parent;
        this.method_125(Minecraft.field_2791, width, height);
    }

    @ApiStatus.Internal
    public void method_125(Minecraft minecraft, int width, int height) {
        super.method_125(minecraft, width, height);
    }

    @ApiStatus.Internal
    public void method_119() {
        this.id = 100;
        this.field_154.clear();
        this.currentTooltip = null;
        this.searchField = new SearchTextFieldWidget(this.field_156, 0, 0, 0, 20);
        this.searchField.setMaxLength(64);
        this.searchField.setText(AlwaysMoreItems.getItemFilter().getFilterText());
        this.settingsButton = new AMISettingsButton(12, 0, 0);
        this.settingsButton.field_1375 = AlwaysMoreItems.overlayEnabled;
        this.field_154.add(this.settingsButton);
        if (this.isSearchBarCentered()) {
            this.searchField.x = this.field_152 / 2 - searchFieldWidth / 2 - 10;
            this.searchField.y = this.field_153 - 25;
            this.searchField.width = searchFieldWidth - 2;
            this.settingsButton.field_1370 = this.field_152 / 2 - searchFieldWidth / 2 + searchFieldWidth - 11;
            this.settingsButton.field_1371 = this.field_153 - 26;
        } else {
            this.searchField.x = this.field_152 - this.getItemListWidth() * 18;
            this.searchField.y = this.field_153 - 21;
            this.searchField.width = this.field_152 - 23 - this.searchField.x;
            this.settingsButton.field_1370 = this.field_152 - 22;
            this.settingsButton.field_1371 = this.field_153 - 22;
        }
        this.previousButton = new class_33(10, this.getOverlayStartX() - 1, 0, 20, 20, "<");
        this.previousButton.field_1375 = AlwaysMoreItems.overlayEnabled;
        this.field_154.add(this.previousButton);
        this.nextButton = new class_33(11, this.field_152 - 20, 0, 20, 20, ">");
        this.nextButton.field_1375 = AlwaysMoreItems.overlayEnabled;
        this.field_154.add(this.nextButton);
        this.initActionButtons();
        this.recipesGui.method_119();
    }

    public void initActionButtons() {
        List<OverlayMode> allowedOverlayModes;
        this.actionButtons = new ArrayList();
        int actionButtonX = 0;
        int actionButtonY = 0;
        int maxHeightForLine = 0;
        for (int i = 0; i < ActionButtonRegistry.INSTANCE.size(); ++i) {
            List<OverlayMode> allowedOverlayModes2;
            Identifier identifier = (Identifier)ActionButtonRegistry.INSTANCE.getId(i).get();
            ActionButton actionButton = (ActionButton)ActionButtonRegistry.INSTANCE.get(identifier);
            if (actionButton == null) {
                AlwaysMoreItems.LOGGER.error("Identifier {} somehow returned null", (Object)identifier, (Object)new Throwable());
                continue;
            }
            if (actionButton.dontAddToScreen() || (allowedOverlayModes2 = actionButton.allowedOverlayModes()) != null && !allowedOverlayModes2.contains((Object)AMIConfig.getOverlayMode())) continue;
            if (actionButtonX + actionButton.getWidth() > maxActionButtonPanelWidth) {
                actionButtonX = 0;
                actionButtonY += maxHeightForLine + actionButtonOffset;
                maxHeightForLine = 0;
            }
            if (actionButton.getHeight() > maxHeightForLine) {
                maxHeightForLine = actionButton.getHeight();
            }
            ActionButtonWidget widget = new ActionButtonWidget(this.id++, actionButtonX, actionButtonY, actionButton.getWidth(), actionButton.getHeight(), actionButton.getTexture());
            this.actionButtons.add(widget);
            widget.action = actionButton;
            widget.actionIdentifier = identifier;
            actionButtonX += actionButton.getWidth() + actionButtonOffset;
        }
        this.trashButton = new ActionButtonWidget(this.id + 1, 0, this.field_153 - 20, 90, 20, "button." + AlwaysMoreItems.NAMESPACE + ".trash", "button." + AlwaysMoreItems.NAMESPACE + ".trash.alt");
        this.trashButton.actionIdentifier = AlwaysMoreItems.NAMESPACE.id("trash");
        this.trashButton.action = (ActionButton)ActionButtonRegistry.INSTANCE.get(this.trashButton.actionIdentifier);
        if (this.trashButton.action != null && ((allowedOverlayModes = this.trashButton.action.allowedOverlayModes()) == null || allowedOverlayModes.contains((Object)AMIConfig.getOverlayMode()))) {
            this.actionButtons.add(this.trashButton);
        }
    }

    public void method_122() {
        if (AlwaysMoreItems.overlayEnabled) {
            this.rescale();
            if (AMIConfig.getOverlayMode() != this.lastOverlayMode) {
                this.lastOverlayMode = AMIConfig.getOverlayMode();
                this.initActionButtons();
            }
        }
        this.recipesGui.method_122();
    }

    public void method_118(int mouseX, int mouseY, float delta) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        if (this.parent.hashCode() != this.lastParent) {
            this.checkGuiSize();
            this.lastParent = this.parent.hashCode();
        }
        if (this.recipesGui.isActive()) {
            this.recipesGui.drawBackground();
        }
        super.method_118(mouseX, mouseY, delta);
        this.recipesGui.method_118(mouseX, mouseY, delta);
        this.amiRender(mouseX, mouseY);
        this.recipesGui.drawHovered(mouseX, mouseY);
    }

    public void amiRender(int mouseX, int mouseY) {
        if (!AlwaysMoreItems.overlayEnabled) {
            return;
        }
        this.currentTooltip = null;
        if (this.renderedItems != null) {
            RenderHelper.enableItemLighting();
            for (ItemRenderEntry item : this.renderedItems) {
                if (AMIConfig.isEditModeEnabled()) {
                    if (AMIConfig.isItemOnConfigBlacklist(item.item, false)) {
                        RenderHelper.disableItemLighting();
                        this.method_1932(item.x - 1, item.y - 1, item.x + 17, item.y + 17, ColorHelper.Argb.getArgb((int)255, (int)255, (int)0, (int)0));
                        RenderHelper.enableItemLighting();
                    } else if (AMIConfig.isItemOnConfigBlacklist(item.item, true)) {
                        RenderHelper.disableItemLighting();
                        this.method_1932(item.x - 1, item.y - 1, item.x + 17, item.y + 17, ColorHelper.Argb.getArgb((int)255, (int)255, (int)255, (int)0));
                        RenderHelper.enableItemLighting();
                    }
                }
                RenderHelper.drawItemStack(item.x, item.y, item.item, true);
            }
            RenderHelper.disableItemLighting();
        }
        this.hoveredItem = this.getHoveredItem(mouseX, mouseY);
        if (this.hoveredItem != null) {
            this.method_1932(this.hoveredItem.x - 1, this.hoveredItem.y - 1, this.hoveredItem.x + itemSize - 1, this.hoveredItem.y + itemSize - 1, -2130706433);
            String simpleTip = class_300.method_992().method_993(this.hoveredItem.item.method_726() + ".name");
            this.currentTooltip = TooltipHelper.getTooltipForItemStack((String)simpleTip, (class_31)this.hoveredItem.item, (class_136)Minecraft.field_2791.field_2806.field_519, null);
        }
        String pageNumberString = (this.pageCount == 0 ? 0 : this.currentPage + 1) + "/" + this.pageCount;
        this.field_156.method_1903(pageNumberString, this.field_152 - (this.field_152 - this.getOverlayStartX()) / 2 - this.field_156.method_1901(pageNumberString) / 2, 6, -1);
        this.searchField.draw(mouseX, mouseY);
        for (ActionButtonWidget actionButton : this.actionButtons) {
            actionButton.method_1186(this.field_151, mouseX, mouseY);
            if (!actionButton.action.tooltipEnabled() || this.currentTooltip != null || !actionButton.method_1189(this.field_151, mouseX, mouseY)) continue;
            boolean holdingShift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            String translationKey = AlwaysMoreItems.NAMESPACE + ".actionButton." + actionButton.actionIdentifier.namespace + "." + actionButton.actionIdentifier.path;
            if (holdingShift && !class_300.method_992().method_993(translationKey + ".alt").equals(translationKey + ".alt")) {
                this.currentTooltip = Collections.singletonList(class_300.method_992().method_993(translationKey + ".alt"));
                continue;
            }
            this.currentTooltip = Collections.singletonList(class_300.method_992().method_993(translationKey));
        }
        if (Minecraft.field_2791.field_2806.field_519.method_689() != null && mouseX >= this.getOverlayStartX() && mouseY > 21) {
            this.currentTooltip = new ArrayList<String>(){
                {
                    this.add(class_300.method_992().method_994("button.alwaysmoreitems.trash.cursor", new Object[]{class_300.method_992().method_993(Minecraft.field_2791.field_2806.field_519.method_689().method_726() + ".name")}));
                }
            };
        }
        if (this.currentTooltip != null && !this.currentTooltip.isEmpty()) {
            Tooltip.INSTANCE.setTooltip(new ArrayList<Object>(this.currentTooltip), mouseX, mouseY);
        }
    }

    public void method_124(int mouseX, int mouseY, int button) {
        this.recipesGui.method_124(mouseX, mouseY, button);
        if (!AlwaysMoreItems.overlayEnabled) {
            return;
        }
        super.method_124(mouseX, mouseY, button);
        if (Minecraft.field_2791.field_2806.field_519.method_689() != null && mouseX >= this.getOverlayStartX() && mouseY > 21) {
            if (!this.field_151.field_2804.field_180) {
                this.trashButton.performAction(this.field_151, this.field_151.field_2804, (class_54)this.field_151.field_2806, true, button, false);
            } else {
                PacketHelper.send((class_169)new ActionButtonPacket(this.trashButton.actionIdentifier, button, false));
            }
            return;
        }
        this.searchField.mouseClicked(mouseX, mouseY, button);
        if (ItemFilter.setFilterText(this.searchField.getText())) {
            this.rebuildRenderList();
        }
        for (ActionButtonWidget actionButton : this.actionButtons) {
            boolean holdingShift;
            if (!actionButton.method_1189(this.field_151, mouseX, mouseY)) continue;
            this.field_151.field_2766.method_2009(actionButton.action.getClickSound(), 1.0f, 1.0f);
            boolean bl = holdingShift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            if (!this.field_151.field_2804.field_180 || actionButton.action.isClientsideOnly()) {
                actionButton.performAction(this.field_151, this.field_151.field_2804, (class_54)this.field_151.field_2806, true, button, holdingShift);
                continue;
            }
            PacketHelper.send((class_169)new ActionButtonPacket(actionButton.actionIdentifier, button, holdingShift));
        }
        if (this.hoveredItem != null) {
            if (AMIConfig.isEditModeEnabled() && button == 0) {
                boolean isCtrl = Keyboard.isKeyDown((int)29);
                if (!AMIConfig.isItemOnConfigBlacklist(this.hoveredItem.item, isCtrl)) {
                    AMIConfig.addItemToConfigBlacklist(this.hoveredItem.item, isCtrl);
                } else {
                    AMIConfig.removeItemFromConfigBlacklist(this.hoveredItem.item, isCtrl);
                }
                return;
            }
            if (AMIConfig.getOverlayMode() != OverlayMode.CHEAT || this.recipesGui.isActive()) {
                if (button == 0) {
                    this.showRecipe(new Focus(this.hoveredItem.item));
                } else if (button == 1) {
                    this.showUses(new Focus(this.hoveredItem.item));
                }
                return;
            }
            if (AlwaysMoreItems.isAMIOnServer()) {
                class_8 itemNbt = new class_8();
                this.hoveredItem.item.method_706(itemNbt);
                if (button == 0) {
                    itemNbt.method_1012("Count", (byte)this.hoveredItem.item.method_709());
                } else if (button == 1) {
                    itemNbt.method_1012("Count", (byte)Math.min(AMIConfig.getRightClickGiveAmount(), this.hoveredItem.item.method_709()));
                } else {
                    return;
                }
                PacketHelper.send((class_169)new GiveItemPacket(itemNbt));
            } else if (button == 0) {
                Commands.giveStack(this.hoveredItem.item, this.hoveredItem.item.method_709());
            } else if (button == 1) {
                Commands.giveStack(this.hoveredItem.item, Math.min(AMIConfig.getRightClickGiveAmount(), this.hoveredItem.item.method_709()));
            }
        }
    }

    public void method_131() {
        if (!AlwaysMoreItems.overlayEnabled) {
            return;
        }
        super.method_131();
        int mouseX = Mouse.getEventX() * this.field_152 / this.field_151.field_2802;
        int dWheel = Mouse.getEventDWheel();
        if (mouseX >= this.getOverlayStartX() && dWheel != 0) {
            if (this.flipScrollDirection) {
                this.flipPage(dWheel);
            } else {
                this.flipPage(-dWheel);
            }
        }
    }

    public void method_117(char character, int keyCode) {
        if (INSTANCE.overlayKeyPressed(character, keyCode)) {
            return;
        }
        super.method_117(character, keyCode);
    }

    public boolean overlayKeyPressed(char character, int keyCode) {
        class_293 handled;
        class_133 hoveredSlot;
        class_32 class_323;
        if (keyCode == KeybindListener.toggleOverlay.field_2381 && !this.searchField.isSelected()) {
            AlwaysMoreItems.overlayEnabled = !AlwaysMoreItems.overlayEnabled;
            this.screenScaler = new class_564(this.field_151.field_2824, this.field_151.field_2802, this.field_151.field_2803);
            this.field_151.field_2816.method_125(this.field_151, this.screenScaler.method_1857(), this.screenScaler.method_1858());
            this.previousButton.field_1375 = this.previousButton.field_1374 = AlwaysMoreItems.overlayEnabled;
            this.nextButton.field_1375 = this.nextButton.field_1374 = AlwaysMoreItems.overlayEnabled;
            this.settingsButton.field_1375 = this.settingsButton.field_1374 = AlwaysMoreItems.overlayEnabled;
        }
        if (this.recipesGui.recipeKeyPressed(keyCode)) {
            return true;
        }
        if (!AlwaysMoreItems.overlayEnabled) {
            return false;
        }
        if (this.searchField.isSelected()) {
            this.searchField.keyPressed(character, keyCode);
            ItemFilter.setFilterText(this.searchField.getText());
            this.currentPage = 0;
            this.rebuildRenderList();
            return true;
        }
        if (this.hoveredItem != null) {
            if (keyCode == KeybindListener.showRecipe.field_2381) {
                this.showRecipe(new Focus(this.hoveredItem.item));
                return true;
            }
            if (keyCode == KeybindListener.showUses.field_2381) {
                this.showUses(new Focus(this.hoveredItem.item));
                return true;
            }
        }
        if ((class_323 = this.parent) instanceof class_293 && (hoveredSlot = (handled = (class_293)class_323).method_986(this.lastMouseX, this.lastMouseY)) != null && hoveredSlot.method_476()) {
            if (keyCode == KeybindListener.showRecipe.field_2381) {
                this.recipesGui.showRecipes(new Focus(hoveredSlot.method_472()));
                return true;
            }
            if (keyCode == KeybindListener.showUses.field_2381) {
                this.recipesGui.showUses(new Focus(hoveredSlot.method_472()));
                return true;
            }
        }
        if (keyCode == KeybindListener.recipeBack.field_2381) {
            this.recipesGui.back();
            return true;
        }
        return false;
    }

    public void showRecipe(Focus item) {
        this.recipesGui.showRecipes(item);
    }

    public void showUses(Focus item) {
        this.recipesGui.showUses(item);
    }

    protected void method_120(class_33 button) {
        this.recipesGui.method_120(button);
        if (button.field_1373 == this.previousButton.field_1373) {
            this.flipPage(-1);
        }
        if (button.field_1373 == this.nextButton.field_1373) {
            this.flipPage(1);
        }
        if (button.field_1373 == this.settingsButton.field_1373) {
            if (Keyboard.isKeyDown((int)29)) {
                GCAPI.reloadConfig((String)AlwaysMoreItems.NAMESPACE.id("config").toString(), (GlassYamlFile)new GlassYamlFile(){
                    {
                        this.set("overlayMode", AMIConfig.getOverlayMode() != OverlayMode.CHEAT ? 1 : 0);
                    }
                });
                this.initActionButtons();
                return;
            }
            if (Keyboard.isKeyDown((int)42)) {
                GCAPI.reloadConfig((String)AlwaysMoreItems.NAMESPACE.id("config").toString(), (GlassYamlFile)new GlassYamlFile(){
                    {
                        this.set("overlayMode", AMIConfig.getOverlayMode() != OverlayMode.UTILITY ? 2 : 0);
                    }
                });
                this.initActionButtons();
                return;
            }
            try {
                Minecraft.field_2791.method_2112((class_32)GCAPI.getRootConfigScreen((String)AlwaysMoreItems.NAMESPACE.id("config").toString(), (class_32)this.parent));
            }
            catch (AttributeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void rescale() {
        if (this.field_151 == null) {
            this.field_151 = Minecraft.field_2791;
        }
        this.screenScaler = new class_564(this.field_151.field_2824, this.field_151.field_2802, this.field_151.field_2803);
        if (this.field_151.field_2802 != this.lastWidth || this.field_151.field_2803 != this.lastHeight || AMIConfig.INSTANCE.maxItemListWidth != this.lastItemWidth || AMIConfig.INSTANCE.maxItemListHeight != this.lastItemHeight || this.screenScaler.method_1857() != this.lastScaledWidth || this.isSearchBarCentered() != this.lastCenteredBar) {
            maxItemListWidth = AMIConfig.INSTANCE.maxItemListWidth;
            maxItemListHeight = AMIConfig.INSTANCE.maxItemListHeight;
            this.field_152 = this.screenScaler.method_1857();
            this.field_153 = this.screenScaler.method_1858();
            this.lastWidth = this.field_151.field_2802;
            this.lastHeight = this.field_151.field_2803;
            this.lastItemWidth = maxItemListWidth;
            this.lastItemHeight = maxItemListHeight;
            this.lastScaledWidth = this.field_152;
            this.lastCenteredBar = this.isSearchBarCentered();
            this.currentPage = 0;
            this.field_151.field_2816.method_125(this.field_151, this.screenScaler.method_1857(), this.screenScaler.method_1858());
            this.rebuildRenderList();
        }
    }

    private void checkGuiSize() {
        int itemListWidth = this.getItemListWidth();
        int itemListHeight = this.getItemListHeight();
        if (itemListWidth != this.lastItemListWidth || itemListHeight != this.lastItemListHeight) {
            this.currentPage = 0;
            this.field_151.field_2816.method_125(this.field_151, this.screenScaler.method_1857(), this.screenScaler.method_1858());
            this.rebuildRenderList();
        }
    }

    public int getItemListWidth() {
        int possibleOverlayStartX;
        class_32 class_323 = this.parent;
        if (class_323 instanceof class_293) {
            class_293 handledScreen = (class_293)class_323;
            possibleOverlayStartX = (this.parent.field_152 - handledScreen.field_1152) / 2 + handledScreen.field_1152 + 10;
        } else {
            class_323 = this.parent;
            if (class_323 instanceof RecipesGui) {
                RecipesGui recipesGuiParent = (RecipesGui)class_323;
                possibleOverlayStartX = (this.parent.field_152 - recipesGuiParent.getXSize()) / 2 + recipesGuiParent.getXSize() + 10;
            } else {
                throw new RuntimeException("Unsupported Screen fed to OverlayScreen!");
            }
        }
        return Math.min((this.field_152 - possibleOverlayStartX) / itemSize, maxItemListWidth);
    }

    public int getItemListHeight() {
        if (this.isSearchBarCentered()) {
            return Math.min((this.field_153 - 20) / itemSize, maxItemListHeight);
        }
        return Math.min((this.field_153 - 42) / itemSize, maxItemListHeight);
    }

    public boolean isSearchBarCentered() {
        if (this.screenScaler == null) {
            this.screenScaler = new class_564(this.field_151.field_2824, this.field_151.field_2802, this.field_151.field_2803);
        }
        return AMIConfig.centeredSearchBar() && (this.screenScaler.method_1858() > 275 || !(this.field_151.field_2816 instanceof class_264));
    }

    public int getOverlayStartX() {
        return this.field_152 - this.getItemListWidth() * itemSize;
    }

    public ItemRenderEntry getHoveredItem(int mouseX, int mouseY) {
        if (this.renderedItems == null || !AlwaysMoreItems.overlayEnabled) {
            return null;
        }
        if (mouseY <= 21 || mouseX < this.getOverlayStartX()) {
            return null;
        }
        int itemX = (mouseX - this.getOverlayStartX()) / itemSize;
        int itemY = (mouseY - 21) / itemSize;
        int itemIndexOnPage = itemY * this.getItemListWidth() + itemX;
        if (itemIndexOnPage < this.renderedItems.size() && itemIndexOnPage >= 0) {
            return this.renderedItems.get(itemIndexOnPage);
        }
        return null;
    }

    public void rebuildRenderList() {
        ImmutableList<ItemStackElement> filteredItems = AlwaysMoreItems.getItemFilter().getItemList();
        this.renderedItems = new ArrayList();
        int itemListWidth = this.getItemListWidth();
        int itemListHeight = this.getItemListHeight();
        int overlayStartX = this.getOverlayStartX();
        int itemsPerPage = itemListWidth * itemListHeight;
        this.pageCount = (int)Math.ceil((double)filteredItems.size() / (double)itemsPerPage);
        this.lastItemListWidth = itemListWidth;
        this.lastItemListHeight = itemListHeight;
        for (int yIndex = 0; yIndex < itemListHeight; ++yIndex) {
            for (int xIndex = 0; xIndex < itemListWidth; ++xIndex) {
                int itemIndexOnThisPage = yIndex * itemListWidth + xIndex;
                int itemIndex = this.currentPage * itemsPerPage + itemIndexOnThisPage;
                if (itemIndex >= filteredItems.size()) {
                    return;
                }
                this.renderedItems.add(new ItemRenderEntry(overlayStartX + xIndex * itemSize, 21 + yIndex * itemSize, ((ItemStackElement)filteredItems.get(itemIndex)).getItemStack()));
            }
        }
    }

    public void flipPage(int direction) {
        if (direction > 0) {
            if (this.currentPage < this.pageCount - 1) {
                ++this.currentPage;
            } else if (this.rolloverPage) {
                this.currentPage = 0;
            }
        } else if (direction < 0) {
            if (this.currentPage > 0) {
                --this.currentPage;
            } else if (this.rolloverPage) {
                this.currentPage = Math.max(this.pageCount - 1, 0);
            }
        }
        this.rebuildRenderList();
    }

    public record ItemRenderEntry(int x, int y, class_31 item) {
    }
}

