package net.glasslauncher.mods.alwaysmoreitems.config;

import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.glasslauncher.mods.gcapi3.api.ConfigRoot;
import net.glasslauncher.mods.gcapi3.api.GCAPI;
import net.glasslauncher.mods.gcapi3.impl.GlassYamlFile;
import net.minecraft.class_31;
import java.io.File;

public class AMIConfig {

    @ConfigRoot(
            value = "config",
            visibleName = "Main Config"
    )
    public static final AMIConfigObject INSTANCE = new AMIConfigObject();

    public static boolean isRecipeAnimationsEnabled() {
        return true;
    }

    public static void addItemToConfigBlacklist(class_31 itemStack, boolean wildcard) {
        if (itemStack == null) {
            return;
        }
        String uid = AlwaysMoreItems.getStackHelper().getUniqueIdentifierForStack(itemStack, wildcard);
        if (INSTANCE.itemBlacklist.add(uid)) {
            updateBlacklist();
        }
    }

    public static void removeItemFromConfigBlacklist(class_31 itemStack, boolean wildcard) {
        if (itemStack == null) {
            return;
        }
        String uid = AlwaysMoreItems.getStackHelper().getUniqueIdentifierForStack(itemStack, wildcard);
        if (INSTANCE.itemBlacklist.remove(uid)) {
            updateBlacklist();
        }
    }

    public static boolean isItemOnConfigBlacklist(class_31 itemStack, boolean wildcard) {
        String uid = AlwaysMoreItems.getStackHelper().getUniqueIdentifierForStack(itemStack, wildcard);
        return INSTANCE.itemBlacklist.contains(uid);
    }

    public static boolean isDebugModeEnabled() {
        return INSTANCE.debugMode;
    }

    public static boolean isEditModeEnabled() {
        return INSTANCE.editMode;
    }

    private static void updateBlacklist() {
        GCAPI.reloadConfig(AlwaysMoreItems.NAMESPACE.id("config").toString(), new GlassYamlFile(new File(FabricLoader.getInstance().getConfigDir().toFile(), AlwaysMoreItems.NAMESPACE + "/config.yml")));
        AlwaysMoreItems.LOGGER.info("Resetting item filter cache.");
        AlwaysMoreItems.getItemFilter().reset();
    }

    public static boolean showModNames() {
        return INSTANCE.showModNames;
    }

    public static int getRightClickGiveAmount() {
        return INSTANCE.rightClickGiveAmount;
    }

    public static boolean showNbtCount() {
        return INSTANCE.showNbtCount;
    }

    public static boolean ignoreUntranslatedNames() {
        return INSTANCE.ignoreUntranslatedNames;
    }

    public static boolean showRedundantItems() {
        return INSTANCE.showRedundantItems;
    }
    
    public static boolean centeredSearchBar(){
        return INSTANCE.centeredSearchBar;
    }
    
    public static OverlayMode getOverlayMode(){
        return INSTANCE.overlayMode;
    }
}
