package net.glasslauncher.mods.alwaysmoreitems.gui.widget;

import net.glasslauncher.mods.alwaysmoreitems.config.AMIConfig;
import net.glasslauncher.mods.alwaysmoreitems.gui.RenderHelper;
import net.minecraft.client.Minecraft;

public class AMISettingsButton extends ActionButtonWidget {
    public AMISettingsButton(int id, int x, int y) {
        super(id, x, y, 22, 22, "");
        iconType = ButtonIconType.OTHER;
    }

    @Override
    public void method_1186(Minecraft minecraft, int mouseX, int mouseY) {
        if(!field_1375) {
            return;
        }
        
        switch (AMIConfig.getOverlayMode()){
            case CHEAT -> texture = "/assets/alwaysmoreitems/stationapi/textures/gui/settings_cheat.png";
            case UTILITY -> texture = "/assets/alwaysmoreitems/stationapi/textures/gui/settings_utility.png";
            default -> texture = "/assets/alwaysmoreitems/stationapi/textures/gui/settings.png";
        }
        
        super.method_1186(minecraft, mouseX, mouseY);
        RenderHelper.bindTexture(texture);
        RenderHelper.drawTexture(field_1370 + 1, field_1371 + 1, field_1368 - 2, field_1369 - 2);
    }
}
