package net.glasslauncher.mods.alwaysmoreitems.transfer;

import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.transfer.RecipeTransferError;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.transfer.RecipeTransferHandler;
import net.glasslauncher.mods.alwaysmoreitems.gui.RecipeLayout;
import net.glasslauncher.mods.alwaysmoreitems.gui.screen.OverlayScreen;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.minecraft.class_293;
import net.minecraft.class_32;
import net.minecraft.class_54;
import net.minecraft.class_71;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecipeTransferUtil {
    public static RecipeTransferError getTransferRecipeError(@Nonnull RecipeLayout recipeLayout, @Nonnull class_54 player) {
        return transferRecipe(recipeLayout, player, false, false);
    }

    public static boolean transferRecipe(@Nonnull RecipeLayout recipeLayout, @Nonnull class_54 player, boolean maxTransfer) {
        RecipeTransferError error = transferRecipe(recipeLayout, player, maxTransfer, true);
        return error == null;
    }

    @Nullable
    private static RecipeTransferError transferRecipe(@Nonnull RecipeLayout recipeLayout, @Nonnull class_54 player, boolean maxTransfer, boolean doTransfer) {
        class_32 parentScreen = OverlayScreen.INSTANCE.parent;
        if (parentScreen instanceof class_293 handledScreen) {
            class_71 container = handledScreen.field_1154;

            RecipeTransferHandler transferHandler = AlwaysMoreItems.getRecipeRegistry().getRecipeTransferHandler(container, recipeLayout.getRecipeCategory());
            if (transferHandler == null) {
                if (doTransfer) {
                    AlwaysMoreItems.LOGGER.error("No Recipe Transfer handler for container {}", container.getClass());
                }
                else if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                    AlwaysMoreItems.LOGGER.warn("No Recipe Transfer handler for container {}", container.getClass());
                }
                return RecipeTransferErrorInternal.instance;
            }

            return transferHandler.transferRecipe(container, recipeLayout, player, maxTransfer, doTransfer);
        }
        return RecipeTransferErrorInternal.instance;
    }
}
