package net.glasslauncher.mods.alwaysmoreitems.network.c2s;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.alwaysmoreitems.network.NetworkHelper;
import net.glasslauncher.mods.alwaysmoreitems.util.AlwaysMoreItems;
import net.minecraft.class_11;
import net.minecraft.class_124;
import net.minecraft.class_169;
import net.minecraft.class_187;
import net.minecraft.class_240;
import net.minecraft.class_31;
import net.minecraft.class_8;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.network.packet.ManagedPacket;
import net.modificationstation.stationapi.api.network.packet.PacketType;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.util.Formatting;
import net.modificationstation.stationapi.api.util.Identifier;
import org.jetbrains.annotations.NotNull;

import java.io.DataInputStream;
import java.io.DataOutputStream;

public class GiveItemPacket extends class_169 implements ManagedPacket<GiveItemPacket> {
    public static final PacketType<GiveItemPacket> TYPE = PacketType.builder(false, true, GiveItemPacket::new).build();
    private static final String STATION_ID = StationAPI.NAMESPACE.id("id").toString();

    private class_8 itemNbt;
    private int dataLength;

    public GiveItemPacket() {
    }

    public GiveItemPacket(class_8 nbt) {
        itemNbt = nbt;
    }

    @Override
    public void method_806(DataInputStream stream) {
        itemNbt = new class_8();
        ((class_187) itemNbt).method_630(stream);
    }

    @Override
    public void method_807(DataOutputStream stream) {
        dataLength = NetworkHelper.writeAndGetNbtLength(itemNbt, stream);
    }

    @Override
    public void method_808(class_240 networkHandler) {
        try {
            handleServer(networkHandler);
        } catch (NoSuchMethodError ignored) {
            handleClient();
        }
    }

    @Environment(EnvType.SERVER)
    public void handleServer(class_240 networkHandler) {
        if (networkHandler instanceof class_11 serverPlay) {
            String id = itemNbt.method_1031(STATION_ID);
            class_124 item = ItemRegistry.INSTANCE.get(Identifier.of(id));

            if (item == null) {
                AlwaysMoreItems.LOGGER.warn("{} tried to give an invalid item with id {}", serverPlay.method_1410(), id);
                return;
            }

            if (!serverPlay.field_919.field_2842.method_584(serverPlay.field_920.field_528)) {
                serverPlay.field_920.method_490(Formatting.RED + "You need to be opped to do this action!");
                return;
            }

            class_31 itemStack = new class_31(itemNbt);
            itemStack.field_751 = Math.min(itemStack.field_751, itemStack.method_709());
            serverPlay.field_920.method_490("Gave " + itemStack.field_751 + " " + itemStack.method_694().method_469() + "@" + itemStack.method_722());
            serverPlay.field_920.field_519.method_671(itemStack);

            // Mark the inventory dirty
            serverPlay.field_920.field_519.method_947();

            // Send content updates to client
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
                if (serverPlay.field_920.field_521 != null) {
                    serverPlay.field_920.field_521.method_2075();
                }
            }
        }
    }

    @Environment(EnvType.CLIENT)
    public void handleClient() {
            String id = itemNbt.method_1031(STATION_ID);
            class_124 item = ItemRegistry.INSTANCE.get(Identifier.of(id));
            if (item == null) {
                AlwaysMoreItems.LOGGER.warn("Invalid item id {}", id);
                return;
            }

            class_31 itemStack = new class_31(itemNbt);
            itemStack.field_751 = Math.min(itemStack.field_751, itemStack.method_709());
            Minecraft.field_2791.field_2806.field_519.method_671(itemStack);
    }

    @Override
    public int method_798() {
        return dataLength;
    }

    @Override
    public @NotNull PacketType<GiveItemPacket> getType() {
        return TYPE;
    }
}
