/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.gui;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.class_322;
import net.minecraft.class_34;
import net.minecraft.class_67;
import net.minecraft.class_76;
import net.minecraft.class_89;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL11;

public class AMITextRenderer
extends class_34 {
    public static final String OBFUSCATED = "\u00a7k";
    public static final String BOLD = "\u00a7l";
    public static final String STRIKETHROUGH = "\u00a7m";
    public static final String UNDERLINE = "\u00a7n";
    public static final String ITALICS = "\u00a7o";
    public static final String RESET = "\u00a7r";
    public static final String RANDOM_CHARS_PALLETTE = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";
    public static final int FONT_HEIGHT = 9;
    public static final Random fontRandom = new Random();
    public static final String VALID_COLOR_CHARS = "0123456789abcdefklmnor";
    public static final int[] COLOR_CODES = new int[32];
    public static final AMITextRenderer INSTANCE;

    public AMITextRenderer(class_322 gameOptions, String texturePath, class_76 textureManager) {
        super(gameOptions, texturePath, textureManager);
    }

    public static int getColorFromCode(char code) {
        return COLOR_CODES[VALID_COLOR_CHARS.indexOf(code)];
    }

    protected float renderChar(int posX, int posY, int character, boolean shadow) {
        int i = character % 16 * 8;
        int j = character / 16 * 8;
        boolean k = shadow;
        int l = this.charWidth(character);
        float f = (float)l - 0.01f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)((float)i / 128.0f), (float)((float)j / 128.0f));
        GL11.glVertex3f((float)((float)posX + (float)k), (float)posY, (float)0.0f);
        GL11.glTexCoord2f((float)((float)i / 128.0f), (float)(((float)j + 7.99f) / 128.0f));
        GL11.glVertex3f((float)((float)posX - (float)k), (float)((float)posY + 7.99f), (float)0.0f);
        GL11.glTexCoord2f((float)(((float)i + f - 1.0f) / 128.0f), (float)((float)j / 128.0f));
        GL11.glVertex3f((float)((float)posX + f - 1.0f + (float)k), (float)posY, (float)0.0f);
        GL11.glTexCoord2f((float)(((float)i + f - 1.0f) / 128.0f), (float)(((float)j + 7.99f) / 128.0f));
        GL11.glVertex3f((float)((float)posX + f - 1.0f - (float)k), (float)((float)posY + 7.99f), (float)0.0f);
        GL11.glEnd();
        return l;
    }

    public int charWidth(int character) {
        int var4 = class_89.field_298.indexOf(character);
        if (var4 >= 0) {
            return this.field_2462[var4 + 32];
        }
        return 0;
    }

    @ApiStatus.Internal
    public void renderStringAtPos(String text, int posX, int posY, Color color, boolean shadow) {
        boolean randomStyle = false;
        boolean boldStyle = false;
        boolean italicStyle = false;
        boolean underlineStyle = false;
        boolean strikethroughStyle = false;
        GL11.glBindTexture((int)3553, (int)this.field_2461);
        this.setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        for (int i = 0; i < text.length(); ++i) {
            boolean flag;
            int j1;
            int i1;
            char c0 = text.charAt(i);
            if (c0 == '\u00a7' && i + 1 < text.length()) {
                i1 = VALID_COLOR_CHARS.indexOf(text.toLowerCase(Locale.ENGLISH).charAt(i + 1));
                if (i1 < 16) {
                    randomStyle = false;
                    boldStyle = false;
                    strikethroughStyle = false;
                    underlineStyle = false;
                    italicStyle = false;
                    if (i1 < 0) {
                        i1 = 15;
                    }
                    if (shadow) {
                        i1 += 16;
                    }
                    j1 = COLOR_CODES[i1];
                    this.setColor(j1 >> 16, j1 >> 8 & 0xFF, j1 & 0xFF, color.getAlpha());
                } else if (i1 == 16) {
                    randomStyle = true;
                } else if (i1 == 17) {
                    boldStyle = true;
                } else if (i1 == 18) {
                    strikethroughStyle = true;
                } else if (i1 == 19) {
                    underlineStyle = true;
                } else if (i1 == 20) {
                    italicStyle = true;
                } else {
                    randomStyle = false;
                    boldStyle = false;
                    strikethroughStyle = false;
                    underlineStyle = false;
                    italicStyle = false;
                    this.setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
                }
                ++i;
                continue;
            }
            i1 = RANDOM_CHARS_PALLETTE.indexOf(c0);
            if (randomStyle && i1 != -1) {
                char c1;
                j1 = this.charWidth(c0);
                while (j1 != this.charWidth(c1 = RANDOM_CHARS_PALLETTE.charAt(i1 = fontRandom.nextInt(RANDOM_CHARS_PALLETTE.length())))) {
                }
                c0 = c1;
            }
            int charScale = 1;
            boolean bl = flag = (c0 == '\u0000' || i1 == -1) && shadow;
            if (flag) {
                posX -= charScale;
                posY -= charScale;
            }
            float f = this.validateAndRenderChar(posX, posY, c0, italicStyle);
            if (flag) {
                posX += charScale;
                posY += charScale;
            }
            if (boldStyle) {
                posX += charScale;
                if (flag) {
                    posX -= charScale;
                    posY -= charScale;
                }
                this.validateAndRenderChar(posX, posY, c0, italicStyle);
                posX -= charScale;
                if (flag) {
                    posX += charScale;
                    posY += charScale;
                }
                f += 1.0f;
            }
            this.doDecorations(posX, posY, f, strikethroughStyle, underlineStyle);
            posX += (int)f;
        }
    }

    protected void setColor(float red, float green, float blue, float alpha) {
        GL11.glColor4f((float)(red / 255.0f), (float)(green / 255.0f), (float)(blue / 255.0f), (float)(alpha / 255.0f));
    }

    private float validateAndRenderChar(int posX, int posY, char charToRender, boolean shadow) {
        if (charToRender == ' ') {
            return 4.0f;
        }
        int charIndex = RANDOM_CHARS_PALLETTE.indexOf(charToRender);
        return this.renderChar(posX, posY, charIndex, shadow);
    }

    protected void doDecorations(int posX, int posY, float charWidth, boolean strikethroughStyle, boolean underlineStyle) {
        class_67 tessellator1 = null;
        if (strikethroughStyle) {
            tessellator1 = class_67.field_2054;
            GL11.glDisable((int)3553);
            tessellator1.method_1695();
            tessellator1.method_1687((double)posX, (double)((float)posY + 4.0f), 0.0);
            tessellator1.method_1687((double)((float)posX + charWidth), (double)((float)posY + 4.0f), 0.0);
            tessellator1.method_1687((double)((float)posX + charWidth), (double)((float)posY + 4.0f - 1.0f), 0.0);
            tessellator1.method_1687((double)posX, (double)((float)posY + 4.0f - 1.0f), 0.0);
            tessellator1.method_1685();
            if (!underlineStyle) {
                GL11.glEnable((int)3553);
            }
        }
        if (underlineStyle) {
            if (!strikethroughStyle) {
                tessellator1 = class_67.field_2054;
                GL11.glDisable((int)3553);
            }
            tessellator1.method_1695();
            int underlineOffset = -1;
            tessellator1.method_1687((double)((float)posX + (float)underlineOffset), (double)((float)posY + 9.0f), 0.0);
            tessellator1.method_1687((double)((float)posX + charWidth), (double)((float)posY + 9.0f), 0.0);
            tessellator1.method_1687((double)((float)posX + charWidth), (double)((float)posY + 9.0f - 1.0f), 0.0);
            tessellator1.method_1687((double)((float)posX + (float)underlineOffset), (double)((float)posY + 9.0f - 1.0f), 0.0);
            tessellator1.method_1685();
            GL11.glEnable((int)3553);
        }
    }

    public List<String> listFormattedStringToWidth(String p_listFormattedStringToWidth_1_, int p_listFormattedStringToWidth_2_) {
        return Arrays.asList(this.wrapFormattedStringToWidth(p_listFormattedStringToWidth_1_, p_listFormattedStringToWidth_2_).split("\n"));
    }

    String wrapFormattedStringToWidth(String p_wrapFormattedStringToWidth_1_, int p_wrapFormattedStringToWidth_2_) {
        int i = this.sizeStringToWidth(p_wrapFormattedStringToWidth_1_, p_wrapFormattedStringToWidth_2_);
        if (p_wrapFormattedStringToWidth_1_.length() <= i) {
            return p_wrapFormattedStringToWidth_1_;
        }
        String s = p_wrapFormattedStringToWidth_1_.substring(0, i);
        char c0 = p_wrapFormattedStringToWidth_1_.charAt(i);
        boolean flag = c0 == ' ' || c0 == '\n';
        String s1 = AMITextRenderer.getFormatFromString(s) + p_wrapFormattedStringToWidth_1_.substring(i + (flag ? 1 : 0));
        return s + "\n" + this.wrapFormattedStringToWidth(s1, p_wrapFormattedStringToWidth_2_);
    }

    private int sizeStringToWidth(String p_sizeStringToWidth_1_, int p_sizeStringToWidth_2_) {
        int k;
        int i = p_sizeStringToWidth_1_.length();
        int j = 0;
        int l = -1;
        boolean flag = false;
        for (k = 0; k < i; ++k) {
            char c0 = p_sizeStringToWidth_1_.charAt(k);
            switch (c0) {
                case '\n': {
                    --k;
                    break;
                }
                case ' ': {
                    l = k;
                }
                default: {
                    j += this.charWidth(c0);
                    if (!flag) break;
                    ++j;
                    break;
                }
                case '\u00a7': {
                    char c1;
                    if (k >= i - 1) break;
                    if ((c1 = p_sizeStringToWidth_1_.charAt(++k)) != 'l' && c1 != 'L') {
                        if (c1 != 'r' && c1 != 'R' && !AMITextRenderer.isFormatColor(c1)) break;
                        flag = false;
                        break;
                    }
                    flag = true;
                }
            }
            if (c0 == '\n') {
                l = ++k;
                break;
            }
            if (j > p_sizeStringToWidth_2_) break;
        }
        return k != i && l != -1 && l < k ? l : k;
    }

    public static String getFormatFromString(String p_getFormatFromString_0_) {
        StringBuilder s = new StringBuilder();
        int i = -1;
        int j = p_getFormatFromString_0_.length();
        while ((i = p_getFormatFromString_0_.indexOf(167, i + 1)) != -1) {
            if (i >= j - 1) continue;
            char c0 = p_getFormatFromString_0_.charAt(i + 1);
            if (AMITextRenderer.isFormatColor(c0)) {
                s = new StringBuilder("\u00a7" + c0);
                continue;
            }
            if (!AMITextRenderer.isFormatSpecial(c0)) continue;
            s.append("\u00a7").append(c0);
        }
        return s.toString();
    }

    private static boolean isFormatColor(char p_isFormatColor_0_) {
        return p_isFormatColor_0_ >= '0' && p_isFormatColor_0_ <= '9' || p_isFormatColor_0_ >= 'a' && p_isFormatColor_0_ <= 'f' || p_isFormatColor_0_ >= 'A' && p_isFormatColor_0_ <= 'F';
    }

    private static boolean isFormatSpecial(char p_isFormatSpecial_0_) {
        return p_isFormatSpecial_0_ >= 'k' && p_isFormatSpecial_0_ <= 'o' || p_isFormatSpecial_0_ >= 'K' && p_isFormatSpecial_0_ <= 'O' || p_isFormatSpecial_0_ == 'r' || p_isFormatSpecial_0_ == 'R';
    }

    static {
        for (int i = 0; i < 32; ++i) {
            int j = (i >> 3 & 1) * 85;
            int k = (i >> 2 & 1) * 170 + j;
            int l = (i >> 1 & 1) * 170 + j;
            int i1 = (i & 1) * 170 + j;
            if (i == 6) {
                k += 85;
            }
            if (i >= 16) {
                k /= 4;
                l /= 4;
                i1 /= 4;
            }
            AMITextRenderer.COLOR_CODES[i] = (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
        }
        INSTANCE = new AMITextRenderer(Minecraft.field_2791.field_2824, "/font/default.png", Minecraft.field_2791.field_2814);
    }
}

