/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.gui;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.AMIDrawable;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeCategory;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeWrapper;
import net.glasslauncher.mods.alwaysmoreitems.config.AMIConfig;
import net.glasslauncher.mods.alwaysmoreitems.gui.RenderHelper;
import net.glasslauncher.mods.alwaysmoreitems.gui.Tooltip;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.RecipeTransferButton;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.ingredients.GuiIngredient;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.ingredients.GuiItemStackGroup;
import net.glasslauncher.mods.alwaysmoreitems.recipe.Focus;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class RecipeLayout
implements net.glasslauncher.mods.alwaysmoreitems.api.gui.RecipeLayout {
    private static final int RECIPE_BUTTON_SIZE = 12;
    public static final int recipeTransferButtonIndex = 100;
    @Nonnull
    private final RecipeCategory recipeCategory;
    @Nonnull
    private final GuiItemStackGroup guiItemStackGroup;
    @Nonnull
    private final RecipeTransferButton recipeTransferButton;
    @Nonnull
    private final RecipeWrapper recipeWrapper;
    private final int posX;
    private final int posY;

    public RecipeLayout(int index, int posX, int posY, @Nonnull RecipeCategory recipeCategory, @Nonnull RecipeWrapper recipeWrapper, @Nonnull Focus focus) {
        this.recipeCategory = recipeCategory;
        this.guiItemStackGroup = new GuiItemStackGroup();
        int width = recipeCategory.getBackground().getWidth();
        int height = recipeCategory.getBackground().getHeight();
        this.recipeTransferButton = new RecipeTransferButton(100 + index, posX + width + 2, posY + height - 12, 12, 12, "gui.alwaysmoreitems.transferRecipesCharacter");
        this.posX = posX;
        this.posY = posY;
        this.recipeWrapper = recipeWrapper;
        this.guiItemStackGroup.setFocus(focus);
        this.recipeCategory.setRecipe(this, recipeWrapper);
    }

    public void tickWrapper(boolean hovered) {
        this.recipeWrapper.tick(hovered);
    }

    public void draw(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.posX, (float)this.posY, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        AMIDrawable background = this.recipeCategory.getBackground();
        background.draw(minecraft);
        this.recipeCategory.drawExtras(minecraft);
        if (AMIConfig.isRecipeAnimationsEnabled()) {
            this.recipeCategory.drawAnimations(minecraft);
            this.recipeWrapper.drawAnimations(minecraft, background.getWidth(), background.getHeight());
        }
        GL11.glTranslatef((float)(-this.posX), (float)(-this.posY), (float)0.0f);
        this.recipeTransferButton.method_1186(minecraft, mouseX, mouseY);
        GL11.glDisable((int)3042);
        GL11.glTranslatef((float)this.posX, (float)this.posY, (float)0.0f);
        GL11.glDisable((int)2896);
        int recipeMouseX = mouseX - this.posX;
        int recipeMouseY = mouseY - this.posY;
        try {
            this.recipeWrapper.drawInfo(minecraft, background.getWidth(), background.getHeight(), recipeMouseX, recipeMouseY);
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        RenderHelper.enableItemLighting();
        Object hoveredItemStack = this.guiItemStackGroup.draw(minecraft, recipeMouseX, recipeMouseY);
        RenderHelper.disableItemLighting();
        if (hoveredItemStack != null) {
            RenderHelper.enableItemLighting();
            ((GuiIngredient)hoveredItemStack).drawHovered(minecraft, mouseX, mouseY);
            RenderHelper.disableItemLighting();
        } else if (recipeMouseX >= 0 && recipeMouseX < background.getWidth() && recipeMouseY >= 0 && recipeMouseY < background.getHeight()) {
            ArrayList<Object> tooltipStrings = null;
            try {
                tooltipStrings = this.recipeWrapper.getTooltip(recipeMouseX, recipeMouseY);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
            if (tooltipStrings != null && !tooltipStrings.isEmpty()) {
                Tooltip.INSTANCE.setTooltip(tooltipStrings, mouseX, mouseY);
            }
        }
        GL11.glPopMatrix();
    }

    public Focus getFocusUnderMouse(int mouseX, int mouseY) {
        Focus focus = this.guiItemStackGroup.getFocusUnderMouse(mouseX - this.posX, mouseY - this.posY);
        return focus;
    }

    public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        try {
            return this.recipeWrapper.handleClick(minecraft, mouseX - this.posX, mouseY - this.posY, mouseButton);
        }
        catch (AbstractMethodError ignored) {
            return false;
        }
    }

    public boolean handleMouseScrolled(@Nonnull Minecraft minecraft, int mouseX, int mouseY, double scrollDelta) {
        return this.recipeWrapper.handleMouseScrolled(minecraft, mouseX - this.posX, mouseY - this.posY, scrollDelta);
    }

    public boolean handleKeyPress(@Nonnull Minecraft minecraft, char character, int keyCode) {
        return this.recipeWrapper.handleKeyPress(minecraft, character, keyCode);
    }

    @Override
    @Nonnull
    public GuiItemStackGroup getItemStacks() {
        return this.guiItemStackGroup;
    }

    @Override
    public void setRecipeTransferButton(int posX, int posY) {
        this.recipeTransferButton.field_1370 = posX + this.posX;
        this.recipeTransferButton.field_1371 = posY + this.posY;
    }

    @Nonnull
    public RecipeTransferButton getRecipeTransferButton() {
        return this.recipeTransferButton;
    }

    @Nonnull
    public RecipeWrapper getRecipeWrapper() {
        return this.recipeWrapper;
    }

    @Nonnull
    public RecipeCategory getRecipeCategory() {
        return this.recipeCategory;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }
}

