/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.gui.screen;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.glasslauncher.mods.alwaysmoreitems.api.gui.AMIDrawable;
import net.glasslauncher.mods.alwaysmoreitems.api.recipe.RecipeCategory;
import net.glasslauncher.mods.alwaysmoreitems.gui.RecipeLayout;
import net.glasslauncher.mods.alwaysmoreitems.gui.Tooltip;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.ActionButtonWidget;
import net.glasslauncher.mods.alwaysmoreitems.gui.widget.RecipeTransferButton;
import net.glasslauncher.mods.alwaysmoreitems.init.KeybindListener;
import net.glasslauncher.mods.alwaysmoreitems.recipe.Focus;
import net.glasslauncher.mods.alwaysmoreitems.transfer.RecipeTransferUtil;
import net.glasslauncher.mods.alwaysmoreitems.util.HoverChecker;
import net.glasslauncher.mods.alwaysmoreitems.util.RecipeGuiLogic;
import net.glasslauncher.mods.alwaysmoreitems.util.StringUtil;
import net.minecraft.class_300;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_35;
import net.minecraft.class_40;
import net.minecraft.class_54;
import net.minecraft.class_564;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class RecipesGui
extends class_32 {
    private static final int borderPadding = 8;
    private static final int textPadding = 5;
    private boolean active = false;
    public class_32 parent;
    private int titleHeight;
    private int headerHeight;
    private int buttonWidth;
    private final RecipeGuiLogic logic = new RecipeGuiLogic();
    @Nonnull
    private final List<RecipeLayout> recipeLayouts = new ArrayList<RecipeLayout>();
    private String pageString;
    private String title;
    private String backgroundTexture;
    private HoverChecker titleHoverChecker;
    private ActionButtonWidget nextRecipeCategory;
    private ActionButtonWidget previousRecipeCategory;
    private ActionButtonWidget nextPage;
    private ActionButtonWidget previousPage;
    @Nullable
    private RecipeLayout hovered;
    private int guiLeft;
    private int guiTop;
    private int xSize;
    private int ySize;

    public void method_119() {
        this.field_151 = Minecraft.field_2791;
        if (this.field_151.field_2816 == null) {
            return;
        }
        this.field_157 = new class_35(this.field_151);
        this.field_156 = this.field_151.field_2815;
        this.field_154.clear();
        this.xSize = 176;
        if (this.field_153 > 300) {
            this.ySize = 256;
            this.backgroundTexture = "/assets/alwaysmoreitems/stationapi/textures/gui/recipeBackgroundTall.png";
        } else {
            this.ySize = 166;
            this.backgroundTexture = "/assets/alwaysmoreitems/stationapi/textures/gui/recipeBackground.png";
        }
        this.field_152 = this.field_151.field_2816.field_152;
        this.field_153 = this.field_151.field_2816.field_153;
        this.guiLeft = (this.field_152 - this.xSize) / 2;
        this.guiTop = (this.field_153 - this.ySize) / 2;
        this.titleHeight = 17;
        this.headerHeight = this.titleHeight + 9 + 5;
        this.buttonWidth = 13;
        int buttonHeight = 12;
        int rightButtonX = this.guiLeft + this.xSize - 8 - this.buttonWidth;
        int leftButtonX = this.guiLeft + 8;
        int recipeClassButtonTop = this.guiTop + 8 - 2;
        this.nextRecipeCategory = new ActionButtonWidget(2, rightButtonX, recipeClassButtonTop, this.buttonWidth, buttonHeight, "gui.alwaysmoreitems.nextCharacter", "gui.alwaysmoreitems.nextCharacter");
        this.previousRecipeCategory = new ActionButtonWidget(3, leftButtonX, recipeClassButtonTop, this.buttonWidth, buttonHeight, "gui.alwaysmoreitems.previousCharacter", "gui.alwaysmoreitems.previousCharacter");
        int pageButtonTop = this.guiTop + this.titleHeight + 3;
        this.nextPage = new ActionButtonWidget(4, rightButtonX, pageButtonTop, this.buttonWidth, buttonHeight, "gui.alwaysmoreitems.nextCharacter", "gui.alwaysmoreitems.nextCharacter");
        this.previousPage = new ActionButtonWidget(5, leftButtonX, pageButtonTop, this.buttonWidth, buttonHeight, "gui.alwaysmoreitems.previousCharacter", "gui.alwaysmoreitems.previousCharacter");
        this.addButtons();
        this.updateLayout();
    }

    private void addButtons() {
        this.field_154.add(this.nextRecipeCategory);
        this.field_154.add(this.previousRecipeCategory);
        this.field_154.add(this.nextPage);
        this.field_154.add(this.previousPage);
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.guiLeft && mouseY >= this.guiTop && mouseX < this.guiLeft + this.xSize && mouseY < this.guiTop + this.ySize;
    }

    public void method_124(int mouseX, int mouseY, int mouseButton) {
        if (!this.active) {
            return;
        }
        if (!this.isMouseOver(mouseX, mouseY)) {
            super.method_124(mouseX, mouseY, mouseButton);
            return;
        }
        for (RecipeLayout recipeLayout : this.recipeLayouts) {
            if (!recipeLayout.handleClick(this.field_151, mouseX, mouseY, mouseButton)) continue;
            return;
        }
        if (this.titleHoverChecker.isOver(mouseX, mouseY)) {
            boolean success = this.logic.setCategoryFocus();
            if (success) {
                this.updateLayout();
            } else {
                super.method_124(mouseX, mouseY, mouseButton);
            }
            return;
        }
        if (this.hovered != null) {
            Focus focus;
            if (mouseButton == 0 && (focus = this.hovered.getItemStacks().getFocusUnderMouse(mouseX - this.hovered.getPosX(), mouseY - this.hovered.getPosY())) != null) {
                this.showRecipes(focus);
                return;
            }
            if (mouseButton == 1 && (focus = this.hovered.getItemStacks().getFocusUnderMouse(mouseX - this.hovered.getPosX(), mouseY - this.hovered.getPosY())) != null) {
                this.showUses(focus);
                return;
            }
        }
        super.method_124(mouseX, mouseY, mouseButton);
    }

    public void handleMouseScrolled(int mouseX, int mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return;
        }
        int scrollDelta = Mouse.getDWheel();
        if (this.hovered != null && scrollDelta != 0 && this.hovered.handleMouseScrolled(this.field_151, mouseX, mouseY, scrollDelta)) {
            return;
        }
        if (scrollDelta < 0) {
            this.logic.nextPage();
            this.updateLayout();
        } else if (scrollDelta > 0) {
            this.logic.previousPage();
            this.updateLayout();
        }
    }

    public void method_131() {
        if (!this.active) {
            return;
        }
        super.method_131();
    }

    protected void method_117(char character, int keyCode) {
        if (!this.active) {
            return;
        }
        if (this.hovered != null && this.hovered.handleKeyPress(this.field_151, character, keyCode)) {
            return;
        }
        super.method_117(character, keyCode);
    }

    public void open(class_32 newParent) {
        if (newParent != this) {
            this.parent = newParent;
        }
        this.active = true;
        this.method_119();
    }

    public void close() {
        this.active = false;
    }

    public void showRecipes(@Nonnull Focus focus) {
        focus.setMode(Focus.Mode.OUTPUT);
        if (this.logic.setFocus(focus)) {
            this.updateLayout();
            this.open(Minecraft.field_2791.field_2816);
        }
    }

    public void showUses(@Nonnull Focus focus) {
        focus.setMode(Focus.Mode.INPUT);
        if (this.logic.setFocus(focus)) {
            this.updateLayout();
            this.open(Minecraft.field_2791.field_2816);
        }
    }

    public void showCategories(@Nonnull List<String> recipeCategoryUids) {
        if (this.logic.setCategoryFocus(recipeCategoryUids)) {
            this.updateLayout();
            this.open(Minecraft.field_2791.field_2816);
        }
    }

    public void back() {
        if (this.logic.back()) {
            this.updateLayout();
        }
    }

    protected void method_120(@Nonnull class_33 guibutton) {
        boolean updateLayout = true;
        if (guibutton.field_1373 == this.nextPage.field_1373) {
            this.logic.nextPage();
        } else if (guibutton.field_1373 == this.previousPage.field_1373) {
            this.logic.previousPage();
        } else if (guibutton.field_1373 == this.nextRecipeCategory.field_1373) {
            this.logic.nextRecipeCategory();
        } else if (guibutton.field_1373 == this.previousRecipeCategory.field_1373) {
            this.logic.previousRecipeCategory();
        } else if (guibutton.field_1373 >= 100) {
            boolean maxTransfer;
            int recipeIndex = guibutton.field_1373 - 100;
            RecipeLayout recipeLayout = this.recipeLayouts.get(recipeIndex);
            if (RecipeTransferUtil.transferRecipe(recipeLayout, (class_54)this.field_151.field_2806, maxTransfer = Keyboard.isKeyDown((int)42))) {
                this.close();
                updateLayout = false;
            }
        } else {
            updateLayout = false;
        }
        if (updateLayout) {
            this.updateLayout();
        }
    }

    private void updateLayout() {
        RecipeCategory recipeCategory = this.logic.getRecipeCategory();
        if (recipeCategory == null) {
            return;
        }
        AMIDrawable recipeBackground = recipeCategory.getBackground();
        int recipesPerPage = Math.max(1, (this.ySize - this.headerHeight) / (recipeBackground.getHeight() + 8));
        int recipeXOffset = (this.xSize - recipeBackground.getWidth()) / 2;
        int recipeSpacing = (this.ySize - this.headerHeight - recipesPerPage * recipeBackground.getHeight()) / (recipesPerPage + 1);
        this.logic.setRecipesPerPage(recipesPerPage);
        this.title = recipeCategory.getTitle();
        int titleWidth = this.field_156.method_1901(this.title);
        int titleX = this.guiLeft + (this.xSize - titleWidth) / 2;
        int titleY = this.guiTop + 8;
        this.titleHoverChecker = new HoverChecker(titleY, titleY + 9, titleX, titleX + titleWidth);
        int posX = this.guiLeft + recipeXOffset;
        int posY = this.guiTop + this.headerHeight + recipeSpacing;
        int spacingY = recipeBackground.getHeight() + recipeSpacing;
        this.recipeLayouts.clear();
        this.recipeLayouts.addAll(this.logic.getRecipeWidgets(posX, posY, spacingY));
        this.addRecipeTransferButtons(this.recipeLayouts);
        this.nextPage.field_1374 = this.previousPage.field_1374 = this.logic.hasMultiplePages();
        this.nextRecipeCategory.field_1374 = this.previousRecipeCategory.field_1374 = this.logic.hasMultipleCategories();
        this.pageString = this.logic.getPageString();
    }

    private void addRecipeTransferButtons(List<RecipeLayout> recipeLayouts) {
        this.field_154.clear();
        this.addButtons();
        class_40 player = Minecraft.field_2791.field_2806;
        for (RecipeLayout recipeLayout : recipeLayouts) {
            RecipeTransferButton button = recipeLayout.getRecipeTransferButton();
            button.init(recipeLayout, (class_54)player);
            this.field_154.add(button);
        }
    }

    public void method_122() {
        if (!this.active) {
            return;
        }
        for (RecipeLayout recipeLayout : this.recipeLayouts) {
            recipeLayout.tickWrapper(recipeLayout == this.hovered);
        }
        super.method_122();
    }

    public void method_118(int mouseX, int mouseY, float delta) {
        if (!this.active) {
            return;
        }
        this.handleMouseScrolled(mouseX, mouseY);
        Minecraft minecraft = Minecraft.field_2791;
        this.nextRecipeCategory.method_1186(minecraft, mouseX, mouseY);
        this.previousRecipeCategory.method_1186(minecraft, mouseX, mouseY);
        this.nextPage.method_1186(minecraft, mouseX, mouseY);
        this.previousPage.method_1186(minecraft, mouseX, mouseY);
        GL11.glDisable((int)3042);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        this.method_1932(8 + this.buttonWidth, 6, this.xSize - 8 - this.buttonWidth, 18, 0x30000000);
        this.method_1932(8 + this.buttonWidth, this.titleHeight + 5 - 2, this.xSize - 8 - this.buttonWidth, this.titleHeight + 5 + 10, 0x30000000);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        StringUtil.drawCenteredString(this.field_156, this.title, this.xSize, 8, Color.WHITE.getRGB(), true);
        StringUtil.drawCenteredString(this.field_156, this.pageString, this.xSize, this.titleHeight + 5, Color.WHITE.getRGB(), true);
        GL11.glPopMatrix();
        this.hovered = null;
        for (RecipeLayout recipeWidget : this.recipeLayouts) {
            if (recipeWidget.getFocusUnderMouse(mouseX, mouseY) != null) {
                this.hovered = recipeWidget;
                continue;
            }
            recipeWidget.draw(minecraft, mouseX, mouseY);
        }
    }

    public void drawHovered(int mouseX, int mouseY) {
        Focus focus;
        if (!this.active) {
            return;
        }
        if (this.hovered != null) {
            this.hovered.draw(this.field_151, mouseX, mouseY);
        }
        if (this.titleHoverChecker.isOver(mouseX, mouseY) && (focus = this.logic.getFocus()) != null && !focus.isBlank()) {
            Tooltip.INSTANCE.setTooltip((List<Object>)new ArrayList<Object>(){
                {
                    this.add(class_300.method_992().method_993("alwaysmoreitems.tooltip.show.all.recipes"));
                }
            }, mouseX, mouseY);
        }
    }

    public void drawBackground() {
        this.method_134();
        this.bindTexture(this.backgroundTexture);
        this.method_1936(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    private void bindTexture(String texturePath) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.field_2791.field_2814.method_1097(Minecraft.field_2791.field_2814.method_1100(texturePath));
    }

    protected boolean recipeKeyPressed(int keyCode) {
        if (!this.active) {
            return false;
        }
        class_564 screenScaler = new class_564(Minecraft.field_2791.field_2824, Minecraft.field_2791.field_2802, Minecraft.field_2791.field_2803);
        int scaledWidth = screenScaler.method_1857();
        int scaledHeight = screenScaler.method_1858();
        int mouseX = Mouse.getX() * scaledWidth / Minecraft.field_2791.field_2802;
        int mouseY = scaledHeight - Mouse.getY() * scaledHeight / Minecraft.field_2791.field_2803 - 1;
        if (keyCode == 1 || keyCode == this.field_151.field_2824.field_1473.field_2381) {
            this.close();
            return true;
        }
        if (this.hovered != null) {
            Focus focus;
            if (KeybindListener.showRecipe.field_2381 == keyCode && (focus = this.hovered.getItemStacks().getFocusUnderMouse(mouseX - this.hovered.getPosX(), mouseY - this.hovered.getPosY())) != null) {
                this.showRecipes(focus);
                return true;
            }
            if (KeybindListener.showUses.field_2381 == keyCode && (focus = this.hovered.getItemStacks().getFocusUnderMouse(mouseX - this.hovered.getPosX(), mouseY - this.hovered.getPosY())) != null) {
                this.showUses(focus);
                return true;
            }
        }
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }
}

