/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.alwaysmoreitems.util;

import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.alwaysmoreitems.gui.screen.OverlayScreen;
import net.glasslauncher.mods.alwaysmoreitems.init.CommonInit;
import net.glasslauncher.mods.alwaysmoreitems.recipe.ItemBlacklist;
import net.glasslauncher.mods.alwaysmoreitems.recipe.ItemFilter;
import net.glasslauncher.mods.alwaysmoreitems.registry.AMIItemRegistry;
import net.glasslauncher.mods.alwaysmoreitems.registry.RecipeRegistry;
import net.glasslauncher.mods.alwaysmoreitems.util.AMIHelpers;
import net.glasslauncher.mods.alwaysmoreitems.util.StackHelper;
import net.modificationstation.stationapi.api.util.Namespace;
import org.apache.logging.log4j.Logger;

public class AlwaysMoreItems {
    public static final Namespace NAMESPACE = Namespace.resolve();
    public static final Logger LOGGER = NAMESPACE.getLogger();
    private static AMIHelpers helpers;
    private static ItemFilter itemFilter;
    private static AMIItemRegistry itemRegistry;
    private static RecipeRegistry recipeRegistry;
    private static boolean started;
    public static boolean overlayEnabled;

    public static StackHelper getStackHelper() {
        return helpers.getStackHelper();
    }

    public static void resetItemFilter() {
        if (itemFilter != null) {
            itemFilter.reset();
        }
    }

    public static void reloadBlacklist() {
        ItemBlacklist.reset();
        CommonInit.getPlugins().values().forEach(iModPlugin -> {
            try {
                iModPlugin.updateBlacklist(helpers);
            }
            catch (IncompatibleClassChangeError incompatibleClassChangeError) {
                // empty catch block
            }
        });
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && AlwaysMoreItems.getItemFilter() != null) {
            AlwaysMoreItems.getItemFilter().reset();
            OverlayScreen.INSTANCE.rebuildRenderList();
        }
    }

    public static boolean isAMIOnServer() {
        return true;
    }

    public static AMIHelpers getHelpers() {
        return helpers;
    }

    public static void setHelpers(AMIHelpers helpers) {
        AlwaysMoreItems.helpers = helpers;
    }

    public static ItemFilter getItemFilter() {
        return itemFilter;
    }

    public static void setItemFilter(ItemFilter itemFilter) {
        AlwaysMoreItems.itemFilter = itemFilter;
    }

    public static AMIItemRegistry getItemRegistry() {
        return itemRegistry;
    }

    public static void setItemRegistry(AMIItemRegistry itemRegistry) {
        AlwaysMoreItems.itemRegistry = itemRegistry;
    }

    public static RecipeRegistry getRecipeRegistry() {
        return recipeRegistry;
    }

    public static void setRecipeRegistry(RecipeRegistry recipeRegistry) {
        AlwaysMoreItems.recipeRegistry = recipeRegistry;
    }

    public static boolean isStarted() {
        return started;
    }

    public static void setStarted(boolean started) {
        AlwaysMoreItems.started = started;
    }

    static {
        overlayEnabled = true;
    }
}

