package net.glasslauncher.mods.forested.blocks;

import net.glasslauncher.mods.gcapi3.api.CharacterUtils;
import net.minecraft.class_14;
import net.glasslauncher.mods.forested.worldgen.tree.TreeType;
import net.modificationstation.stationapi.api.util.Identifier;

import java.awt.*;
import java.util.Random;

public class ForestedLeavesBlock extends LeavesBlockTemplate {
    private static final Random treeRandom = new Random();
    protected int color;
    private final LazyTreeTypeProvider treeType;

    public ForestedLeavesBlock(Identifier identifier, Color color, LazyTreeTypeProvider treeType) {
        super(identifier);
        this.color = CharacterUtils.getIntFromColour(color);
        this.treeType = treeType;
        setTranslationKey(identifier);
		method_1587(0.2F);
        method_1590(1);
        method_1580(field_1931);
        method_1599();
        method_1591();
    }

    @Override
    public int method_1589(int meta) {
        return color;
    }

    @Override
    public int method_1600(class_14 blockView, int x, int y, int z) {
        return method_1589(blockView.method_1778(x, y, z));
    }

    @Override
    public int method_1601(int blockMeta, Random random) {
        return treeType.getTreeType().sapling.field_1915;
    }

    @FunctionalInterface
    public interface LazyTreeTypeProvider {
        TreeType getTreeType();
    }
}
