package net.glasslauncher.mods.forested.blocks;

import lombok.Getter;
import lombok.Setter;
import net.glasslauncher.mods.forested.worldgen.tree.TreeType;
import net.minecraft.class_18;
import net.modificationstation.stationapi.api.block.HasCustomBlockItemFactory;
import net.modificationstation.stationapi.api.template.block.TemplateSaplingBlock;
import net.modificationstation.stationapi.api.util.Identifier;

import java.util.Random;

@HasCustomBlockItemFactory(ForestedSaplingBlockItem.class)
public class ForestedSaplingBlock extends TemplateSaplingBlock {
    @Setter @Getter
    private TreeType treeType;

    public ForestedSaplingBlock(Identifier identifier) {
        super(identifier, 1);
        method_1587(0.0F);
        method_1580(field_1931);
        setTranslationKey(identifier);
        method_1591();
    }

    @Override
    public int method_1627(int side, int meta) {
        return field_1914;
    }

    @Override
    public void method_533(class_18 world, int x, int y, int z, Random random) {
        world.method_200(x, y, z, 0);
        if (!treeType.feature.generate(world, random, x, y, z)) {
            world.method_200(x, y, z, field_1915);
        }
    }

    @Override
    protected boolean method_1683(int id) {
        return treeType.feature.getSoils().stream().anyMatch(b -> b.field_1915 == id);
    }
}
