package net.glasslauncher.mods.forested.eventlisteners.init;

import net.glasslauncher.mods.forested.registries.TreeRegisterEvent;
import net.glasslauncher.mods.forested.registries.TreeRegistry;
import net.glasslauncher.mods.forested.registries.TreeRegistryEntry;
import net.glasslauncher.mods.forested.worldgen.tree.TreeType;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.mine_diver.unsafeevents.listener.ListenerPriority;
import net.minecraft.class_153;
import net.minecraft.class_186;
import net.minecraft.class_239;
import net.minecraft.class_250;
import net.minecraft.class_349;
import net.minecraft.class_512;
import net.minecraft.class_543;
import net.minecraft.world.gen.feature.*;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.event.world.biome.BiomeRegisterEvent;
import net.modificationstation.stationapi.api.registry.BlockRegistry;
import net.modificationstation.stationapi.api.registry.Registry;
import net.modificationstation.stationapi.api.util.Namespace;

import java.util.Map;

public class TreeGenerationInit {

    @EventListener(priority = ListenerPriority.LOW)
    public static void init(BiomeRegisterEvent event) {
        StationAPI.EVENT_BUS.post(new TreeRegisterEvent());
    }

    @EventListener
    public static void vanillaInit(TreeRegisterEvent event) {
        Registry.register(TreeRegistry.INSTANCE, Namespace.MINECRAFT.id("oak"), new TreeRegistryEntry(new class_543(), Map.of(class_153.field_878, 1000, class_153.field_875, 1000, class_153.field_879, 1000, class_153.field_876, 1000, class_153.field_877, 1000, class_153.field_880, 1000)));
        Registry.register(TreeRegistry.INSTANCE, Namespace.MINECRAFT.id("big_oak"), new TreeRegistryEntry(new class_186(), Map.of(class_153.field_878, 1000, class_153.field_875, 1000, class_153.field_879, 100, class_153.field_876, 100, class_153.field_877, 100, class_153.field_880, 100)));
        Registry.register(TreeRegistry.INSTANCE, Namespace.MINECRAFT.id("spruce"), new TreeRegistryEntry(new class_512(), Map.of(class_153.field_881, 1000)));
        Registry.register(TreeRegistry.INSTANCE, Namespace.MINECRAFT.id("pine"), new TreeRegistryEntry(new class_349(), Map.of(class_153.field_881, 1000)));
        Registry.register(TreeRegistry.INSTANCE, Namespace.MINECRAFT.id("birch"), new TreeRegistryEntry(new class_250(), Map.of(class_153.field_878, 500)));
    }

    @EventListener
    public static void init(TreeRegisterEvent event) {
        for (TreeType treeType : TreeType.values()) {
            Registry.register(TreeRegistry.INSTANCE, BlockRegistry.INSTANCE.getId(treeType.sapling), new TreeRegistryEntry((class_239) treeType.feature, treeType.biomeProvider.getBiomes()));
        }
    }
}
