package net.glasslauncher.mods.forested.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.glasslauncher.mods.forested.ForestedConfig;
import net.glasslauncher.mods.forested.registries.TreeRegistry;
import net.glasslauncher.mods.forested.registries.TreeRegistryEntry;
import net.glasslauncher.mods.forested.util.BlankFeature;
import net.minecraft.class_153;
import net.minecraft.class_208;
import net.minecraft.class_239;
import net.minecraft.class_538;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;

import java.util.Random;

@Mixin({ class_538.class, class_208.class })
public class ChunkGenMixin {
    @Unique
    private static Random random;

    @Unique
    private static final class_239 BLANK_FEATURE = new BlankFeature();

    @WrapOperation(method = "decorate", at = @At(value = "INVOKE", target = "Ljava/util/Random;setSeed(J)V", ordinal = 0))
    private void captureRandom(Random instance, long seed, Operation<Void> original) {
        random = instance;
        original.call(instance, seed);
    }

    @ModifyConstant(method = "decorate", constant = @Constant(intValue = 0, ordinal = 10))
    private int makeDesertsSpawnTrees(int constant, @Local class_153 biome, @Local(ordinal = 4) int treeSample) {
        if (!ForestedConfig.WORLDGEN_CONFIG.generateTrees) {
            return constant;
        }
        int extraChance = 0;

        if ((biome == class_153.field_882 || biome == class_153.field_883 || biome == class_153.field_885) && random.nextInt(100) == 0) {
            extraChance += 20 + treeSample;
        }

        return extraChance;
    }

    @WrapOperation(method = "decorate", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/biome/Biome;getRandomTreeFeature(Ljava/util/Random;)Lnet/minecraft/world/gen/feature/Feature;"))
    public class_239 getCustomTree(class_153 instance, Random random, Operation<class_239> original) {
        if (!ForestedConfig.WORLDGEN_CONFIG.generateTrees) {
            return original.call(instance, random);
        }
        TreeRegistryEntry feature = TreeRegistry.INSTANCE.getTree(random, instance);
        return feature == null ? BLANK_FEATURE : feature.getFeature();
    }
}
