package net.glasslauncher.mods.forested.registries;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import net.minecraft.class_153;
import net.minecraft.class_239;
import java.util.List;
import java.util.Map;

@Getter
@RequiredArgsConstructor
public class TreeRegistryEntry {
    private final class_239 feature;
    private final Object2IntMap<class_153> validBiomes;

    public TreeRegistryEntry(class_239 feature, List<class_153> validBiomes) {
        this.feature = feature;
        this.validBiomes = new Object2IntOpenHashMap<>();
        validBiomes.forEach(e -> this.validBiomes.put(e, 100));
    }

    public TreeRegistryEntry(class_239 feature, Map<class_153, Integer> validBiomes) {
        this.feature = feature;
        this.validBiomes = new Object2IntOpenHashMap<>();
        this.validBiomes.putAll(validBiomes);
    }

    @AllArgsConstructor
    private static class BasicEntry<k, v> implements Map.Entry<k, v> {
        @Getter
        private final k key;
        @Getter
        private v value;

        @Override
        public v setValue(v value) {
            v oldValue = this.value;
            this.value = value;
            return this.value;
        }
    }
}
