package net.glasslauncher.mods.forested.worldgen.tree;

import lombok.RequiredArgsConstructor;
import net.glasslauncher.mods.forested.util.RandomIntProvider;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_239;
import net.modificationstation.stationapi.api.registry.BlockRegistry;

import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;

import static net.glasslauncher.mods.forested.worldgen.tree.TreeGenHelpers.DEFAULT_SOILS;

@RequiredArgsConstructor
public class AlternateOakGen extends class_239 implements ForestedTreeFeature {
    protected final class_17 trunk;
    protected final class_17 leaves;
    protected final RandomIntProvider treeHeightGetter; // random.nextInt(3) + 4
    protected final BiFunction<Random, Integer, Integer> leafRadiusShrinkGetter; // 1 - leafLayer / 2
    protected final RandomIntProvider leafLayerCountGetter; // 3
    protected final Map<class_17, CustomSoilPlacer> soils;

    public AlternateOakGen(class_17 trunk, class_17 leaves, RandomIntProvider treeHeightGetter, BiFunction<Random, Integer, Integer> leafRadiusShrinkGetter, RandomIntProvider leafLayerCountGetter) {
        this.trunk = trunk;
        this.leaves = leaves;
        this.treeHeightGetter = treeHeightGetter;
        this.leafRadiusShrinkGetter = leafRadiusShrinkGetter;
        this.leafLayerCountGetter = leafLayerCountGetter;
        soils = DEFAULT_SOILS;
    }

    @Override
    public boolean method_1142(class_18 world, Random random, int x, int y, int z) {
        int treeHeight = treeHeightGetter.provide(random);
        if (y + treeHeight + 1 > world.getTopY()) {
            return false;
        }

        int supportingBlockId = world.method_1776(x, y - 1, z);
        CustomSoilPlacer soilPlacer = soils.get(BlockRegistry.INSTANCE.getOrThrow(supportingBlockId));
        if (soilPlacer == null || y >= world.getTopY() - treeHeight - 1) {
            return false;
        }

        for(int checkingY = y; checkingY <= y + 1 + treeHeight; ++checkingY) {
            if (checkingY < world.getTopY()) {
                int foundBlockId = world.method_1776(x, checkingY, z);
                if (foundBlockId != 0 && Objects.requireNonNull(BlockRegistry.INSTANCE.get(foundBlockId)).field_1900 == class_15.field_987) {
                    return false;
                }
            } else {
                return false;
            }
        }

        soilPlacer.placeSoil(world, random, x, y - 1, z);

        for(int relativeY = 0; relativeY < treeHeight; ++relativeY) {
            if (TreeGenHelpers.isReplaceableByLogs(world.getBlockState(x, y + relativeY, z))) {
                world.method_200(x, y + relativeY, z, trunk.field_1915);
            }
        }

        for(int placingY = y - leafLayerCountGetter.provide(random) + treeHeight; placingY <= y + treeHeight; ++placingY) {
            int leafLayer = placingY - (y + treeHeight);
            int leafRadiusShrink = leafRadiusShrinkGetter.apply(random, leafLayer);

            for(int placingX = x - leafRadiusShrink; placingX <= x + leafRadiusShrink; ++placingX) {
                int mirroredX = placingX - x;

                for(int placingZ = z - leafRadiusShrink; placingZ <= z + leafRadiusShrink; ++placingZ) {
                    int mirroredZ = placingZ - z;
                    if ((Math.abs(mirroredX) != leafRadiusShrink || Math.abs(mirroredZ) != leafRadiusShrink || random.nextInt(2) != 0 && leafLayer != 0) && !class_17.field_1939[world.method_1776(placingX, placingY, placingZ)]) {
                        world.method_200(placingX, placingY, placingZ, leaves.field_1915);
                    }
                }
            }
        }

        TreeGenHelpers.updateGeneratedLeaves(world, x, y + treeHeight, z);

        return true;
    }

    @Override
    public Set<class_17> getSoils() {
        return soils.keySet();
    }
}
