package net.glasslauncher.mods.forested.worldgen.tree;

import lombok.RequiredArgsConstructor;
import net.glasslauncher.mods.forested.util.RandomIntProvider;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_239;
import net.modificationstation.stationapi.api.registry.BlockRegistry;

import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;

import static net.glasslauncher.mods.forested.worldgen.tree.TreeGenHelpers.DEFAULT_SOILS;

@RequiredArgsConstructor
public class ConifersGen extends class_239 implements ForestedTreeFeature {
    protected final class_17 trunk;
    protected final class_17 leaves;
    protected final RandomIntProvider treeHeightGetter;
    protected final RandomIntProvider topLeafHeightGetter;
    protected final RandomIntProvider maxLeafRadiusGetter;
    protected final RandomIntProvider trunkReductionGetter;
    protected final RandomIntProvider topLeafRadiusGetter;
    protected final RandomIntProvider radiusAfterTopLeafGetter;
    protected final RandomIntProvider leavesConsideredAfterTopGetter;
    protected final RandomIntProvider minLeafRadiusGetter;
    protected final Map<class_17, CustomSoilPlacer> soils;

    public ConifersGen(class_17 trunk, class_17 leaves, RandomIntProvider treeHeightGetter, RandomIntProvider topLeafHeightGetter, RandomIntProvider maxLeafRadiusGetter, RandomIntProvider trunkReductionGetter, RandomIntProvider topLeafRadiusGetter, RandomIntProvider radiusAfterTopLeafGetter, RandomIntProvider leavesConsideredAfterTopGetter, RandomIntProvider minLeafRadiusGetter) {
        this.trunk = trunk;
        this.leaves = leaves;
        this.treeHeightGetter = treeHeightGetter;
        this.topLeafHeightGetter = topLeafHeightGetter;
        this.maxLeafRadiusGetter = maxLeafRadiusGetter;
        this.trunkReductionGetter = trunkReductionGetter;
        this.topLeafRadiusGetter = topLeafRadiusGetter;
        this.radiusAfterTopLeafGetter = radiusAfterTopLeafGetter;
        this.leavesConsideredAfterTopGetter = leavesConsideredAfterTopGetter;
        this.minLeafRadiusGetter = minLeafRadiusGetter;
        soils = DEFAULT_SOILS;
    }

    // Notch, you wrote some draconian bullshit here. Also it performed like crap cause you didn't do the simple checks first.
    @Override
    public boolean method_1142(class_18 world, Random random, int x, int y, int z) {
        int treeHeight = treeHeightGetter.provide(random);

        if (y < 1 || y + treeHeight + 1 > world.getTopY()) {
            return false;
        }

        int supportingBlockId = world.method_1776(x, y - 1, z);
        CustomSoilPlacer soilPlacer = soils.get(BlockRegistry.INSTANCE.getOrThrow(supportingBlockId));
        if (soilPlacer == null || y >= world.getTopY() - treeHeight - 1) {
            return false;
        }

        for (int checkingY = y; checkingY <= y + 1 + treeHeight; checkingY++) {

            if (checkingY >= 0 && checkingY < world.getTopY()) {
                int foundBlock = world.method_1776(x, checkingY, z);
                if (foundBlock != 0 && Objects.requireNonNull(BlockRegistry.INSTANCE.get(foundBlock)).field_1900 == class_15.field_987) {
                    return false;
                }
            } else {
                return false;
            }
        }

        soilPlacer.placeSoil(world, random, x, y - 1, z);
        // Starts at the top, so this decides the top leaf radius, which can be 1 or 0, which gives + type leaves or a spike, respectively.
        int currentLeafRadius = topLeafRadiusGetter.provide(random);
        // Leaves can't get any thinner than this unless it's just after the top and is also a spike. Logs are excluded in this.
        int minLeafRadius = minLeafRadiusGetter.provide(random);
        // If the leaves are going to be too small, minLeafRadius is set to this.
        int nextLoopedRadius = radiusAfterTopLeafGetter.provide(random);

        int topLeafHeight = topLeafHeightGetter.provide(random);
        int trunkHeight = treeHeight - topLeafHeight;
        int maxLeafRadius = maxLeafRadiusGetter.provide(random);
        int treeTrunkReduction = trunkReductionGetter.provide(random);
        int leavesConsiderdAfterTop = leavesConsideredAfterTopGetter.provide(random);
        int leavesSoFar = 0;

        for (int relativeY = 0; relativeY < treeHeight - treeTrunkReduction; relativeY++) {
            if (TreeGenHelpers.isReplaceableByLogs(world.getBlockState(x, y + relativeY, z))) {
                world.method_154(x, y + relativeY, z, trunk.field_1915, 1);
            }
        }

        for (int relativeY = 0; relativeY <= trunkHeight; relativeY++) {
            int placingY = y + treeHeight - relativeY;

            for (int relativeX = x - currentLeafRadius; relativeX <= x + currentLeafRadius; relativeX++) {
                int placingX = relativeX - x;

                for (int relativeZ = z - currentLeafRadius; relativeZ <= z + currentLeafRadius; relativeZ++) {
                    int placingZ = relativeZ - z;
                    if ((Math.abs(placingX) != currentLeafRadius || Math.abs(placingZ) != currentLeafRadius || currentLeafRadius <= 0) && !class_17.field_1939[world.method_1776(relativeX, placingY, relativeZ)]) {
                        world.method_200(relativeX, placingY, relativeZ, leaves.field_1915);
                    }
                }
            }

            if (currentLeafRadius >= minLeafRadius) {
                // The leaves got too small, so set the next looped radius.
                currentLeafRadius = nextLoopedRadius;
                // Set next looped radius to always be 1 after this, which guarantees at least 1 layer of leaves around the trunk after the top of the tree.
                if (leavesConsiderdAfterTop <= leavesSoFar) {
                    nextLoopedRadius = 1;
                }
                // Leaves increase in size until they cap out.
                if (++minLeafRadius > maxLeafRadius) {
                    minLeafRadius = maxLeafRadius;
                }
            } else {
                currentLeafRadius++;
            }
        }

        TreeGenHelpers.updateGeneratedLeaves(world, x, y + treeHeight, z);

        return true;
    }

    @Override
    public Set<class_17> getSoils() {
        return soils.keySet();
    }
}
