package net.glasslauncher.mods.forested.worldgen.tree;

import net.glasslauncher.mods.forested.blocks.LeavesBlockTemplate;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.modificationstation.stationapi.api.block.BlockState;

import java.util.Map;

public class TreeGenHelpers {
    public static final Map<class_17, CustomSoilPlacer> DEFAULT_SOILS = Map.of(class_17.field_1947, (w, r, x, y, z) -> {}, class_17.field_1946, (w, r, x, y, z) -> w.method_200(x, y, z, class_17.field_1947.field_1915));

    public static boolean isReplaceableByLogs(BlockState state) {
        return state.isAir() || !state.isOpaque() || state.getMaterial() == class_15.field_987;
    }

    public static void updateGeneratedLeaves(class_18 world, int x, int y, int z) {
        class_17 block = world.getBlockState(x, y, z).getBlock();
        if (block instanceof LeavesBlockTemplate template) {
            template.updateDecay(world, x, y, z, false);
        }
    }
}
