package net.glasslauncher.mods.landscaped.blocks;

import net.minecraft.class_127;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.block.States;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.registry.tag.BlockTags;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.BooleanProperty;
import net.modificationstation.stationapi.api.state.property.IntProperty;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;

import java.util.Random;


public class LeavesBlockTemplate extends TemplateBlock {
    public static final IntProperty DISTANCE = IntProperty.of("distance", 0, 8);
    public static final BooleanProperty PERSISTENT = BooleanProperty.of("persistent");

    public int maxDistance = 7;
    public int fastTextureId = 1;

    public LeavesBlockTemplate(Identifier identifier) {
        super(identifier, class_15.field_987);
        method_1584(true);
        setDefaultState(getDefaultState().with(DISTANCE, 0).with(PERSISTENT, false));
    }

    @Override
    public BlockState getPlacementState(ItemPlacementContext context) {
        return getDefaultState().with(PERSISTENT, true);
    }

    @Override
    public void method_1614(class_18 world, int x, int y, int z, class_127 placer) {
        updateDecay(world, x, y, z, false);
    }

    @Override
    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(DISTANCE);
        builder.add(PERSISTENT);
    }

    @Override
    public void method_1609(class_18 world, int x, int y, int z, int id) {
        super.method_1609(world, x, y, z, id);
        if (!world.field_180) {
            updateDecay(world, x, y, z, false);
        }
    }

    @Override
    public void method_1602(class_18 world, int x, int y, int z, Random random) {
        super.method_1602(world, x, y, z, random);
        if (!world.field_180) {
            updateDecay(world, x, y, z, true);
        }
    }

    public void updateDecay(class_18 world, int x, int y, int z, boolean decay) {
//        world.addParticle("flame", x + 0.5D, y + 0.5D, z + 0.5D, 0.0D, 0.0D, 0.0D);

        BlockState state = world.getBlockState(x, y, z);

        if (state.get(PERSISTENT)) {
            return;
        }

        int distance = maxDistance + 1;

        for (Direction direction : Direction.values()) {
            distance = Math.min(distance, getDistance(world, x + direction.getOffsetX(), y + direction.getOffsetY(), z + direction.getOffsetZ()) + 1);
            if (distance == 1) {
                break;
            }
        }

        if (decay && distance > this.maxDistance) {
            decay(world, x, y, z);
            return;
        }

        int prevDistance = state.get(DISTANCE);
        if (distance != prevDistance) {
            world.setBlockState(x, y, z, state.with(DISTANCE, distance));
            for (Direction side : Direction.values()) {
                if (world.getBlockState(x + side.getOffsetX(), y + side.getOffsetY(), z + side.getOffsetZ()).contains(DISTANCE)) {
                    updateDecay(world, x + side.getOffsetX(), y + side.getOffsetY(), z + side.getOffsetZ(), false);
                }
            }
        }

    }

    public int getDistance(class_18 world, int x, int y, int z) {
        BlockState state = world.getBlockState(x, y, z);
        if (state.isIn(BlockTags.LOGS)) {
            return 0;
        } else if (state.contains(DISTANCE)) {
            return state.get(DISTANCE);
        }
        return maxDistance;
    }

    public void decay(class_18 world, int x, int y, int z) {
        int meta = world.method_1778(x, y, z);
        world.setBlockStateWithNotify(x, y, z, States.AIR.get());
        this.method_1592(world, x, y, z, meta);
    }

    @Override
    public boolean method_1620() {
        return class_17.field_1832.method_1620();
    }

    @Override
    public boolean method_1618(class_14 blockView, int x, int y, int z, int side) {
        int foundBlockId = blockView.method_1776(x, y, z);
        if (class_17.field_1832.method_1620() && foundBlockId == this.field_1915) {
            return false;
        }

        if (side == 0 && this.field_1921 > 0.0) {
            return true;
        } else if (side == 1 && this.field_1924 < 1.0) {
            return true;
        } else if (side == 2 && this.field_1922 > 0.0) {
            return true;
        } else if (side == 3 && this.field_1925 < 1.0) {
            return true;
        } else if (side == 4 && this.field_1920 > 0.0) {
            return true;
        } else {
            return side == 5 && this.field_1923 < 1.0 || !blockView.method_1783(x, y, z);
        }
    }

    @Override
    public int method_1626(class_14 blockView, int x, int y, int z, int side) {
        return class_17.field_1832.method_1620() ? fastTextureId : field_1914;
    }

    public int method_1603(Random random) {
        return random.nextInt(20) == 0 ? 1 : 0;
    }


}

