/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.forested.registries;

import com.mojang.serialization.Lifecycle;
import java.util.HashMap;
import java.util.Random;
import net.glasslauncher.mods.forested.Forested;
import net.glasslauncher.mods.forested.registries.TreeRegisteringEvent;
import net.glasslauncher.mods.forested.registries.TreeRegistryEntry;
import net.mine_diver.unsafeevents.Event;
import net.minecraft.class_153;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.registry.Registry;
import net.modificationstation.stationapi.api.registry.RegistryEntry;
import net.modificationstation.stationapi.api.registry.RegistryKey;
import net.modificationstation.stationapi.api.registry.SimpleRegistry;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.collection.WeightedList;
import org.jetbrains.annotations.Nullable;

public class TreeRegistry<T extends TreeRegistryEntry>
extends SimpleRegistry<T> {
    public static final TreeRegistry<TreeRegistryEntry> INSTANCE = new TreeRegistry(RegistryKey.ofRegistry((Identifier)Forested.NAMESPACE.id("trees")));
    private final HashMap<class_153, WeightedList<T>> biomeToTrees = new HashMap();

    public TreeRegistry(RegistryKey<? extends Registry<T>> key) {
        super(key, Lifecycle.stable());
    }

    public RegistryEntry.Reference<T> add(RegistryKey<T> registryKey, T value, Lifecycle lifecycle) {
        TreeRegisteringEvent event = new TreeRegisteringEvent((TreeRegistryEntry)value);
        StationAPI.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return null;
        }
        ((TreeRegistryEntry)value).getValidBiomes().forEach((biome, v) -> this.biomeToTrees.computeIfAbsent((class_153)biome, k -> new WeightedList()).add((Object)value, v.intValue()));
        return super.add(registryKey, value, lifecycle);
    }

    @Nullable
    public T getTree(Random random, class_153 biome) {
        WeightedList<T> trees = this.biomeToTrees.get(biome);
        if (trees == null) {
            return null;
        }
        return (T)((TreeRegistryEntry)trees.get(random));
    }
}

