/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.forested.worldgen.tree;

import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import lombok.Generated;
import net.glasslauncher.mods.forested.util.RandomIntProvider;
import net.glasslauncher.mods.forested.worldgen.tree.CustomSoilPlacer;
import net.glasslauncher.mods.forested.worldgen.tree.ForestedTreeFeature;
import net.glasslauncher.mods.forested.worldgen.tree.TreeGenHelpers;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_239;
import net.modificationstation.stationapi.api.registry.BlockRegistry;

public class ConifersGen
extends class_239
implements ForestedTreeFeature {
    protected final class_17 trunk;
    protected final class_17 leaves;
    protected final RandomIntProvider treeHeightGetter;
    protected final RandomIntProvider topLeafHeightGetter;
    protected final RandomIntProvider maxLeafRadiusGetter;
    protected final RandomIntProvider trunkReductionGetter;
    protected final RandomIntProvider topLeafRadiusGetter;
    protected final RandomIntProvider radiusAfterTopLeafGetter;
    protected final RandomIntProvider leavesConsideredAfterTopGetter;
    protected final RandomIntProvider minLeafRadiusGetter;
    protected final Map<class_17, CustomSoilPlacer> soils;

    public ConifersGen(class_17 trunk, class_17 leaves, RandomIntProvider treeHeightGetter, RandomIntProvider topLeafHeightGetter, RandomIntProvider maxLeafRadiusGetter, RandomIntProvider trunkReductionGetter, RandomIntProvider topLeafRadiusGetter, RandomIntProvider radiusAfterTopLeafGetter, RandomIntProvider leavesConsideredAfterTopGetter, RandomIntProvider minLeafRadiusGetter) {
        this.trunk = trunk;
        this.leaves = leaves;
        this.treeHeightGetter = treeHeightGetter;
        this.topLeafHeightGetter = topLeafHeightGetter;
        this.maxLeafRadiusGetter = maxLeafRadiusGetter;
        this.trunkReductionGetter = trunkReductionGetter;
        this.topLeafRadiusGetter = topLeafRadiusGetter;
        this.radiusAfterTopLeafGetter = radiusAfterTopLeafGetter;
        this.leavesConsideredAfterTopGetter = leavesConsideredAfterTopGetter;
        this.minLeafRadiusGetter = minLeafRadiusGetter;
        this.soils = TreeGenHelpers.DEFAULT_SOILS;
    }

    @Override
    public boolean method_1142(class_18 world, Random random, int x, int y, int z) {
        int relativeY;
        int treeHeight = this.treeHeightGetter.provide(random);
        if (y < 1 || y + treeHeight + 1 > world.getTopY()) {
            return false;
        }
        int supportingBlockId = world.method_1776(x, y - 1, z);
        CustomSoilPlacer soilPlacer = this.soils.get(BlockRegistry.INSTANCE.getOrThrow(supportingBlockId));
        if (soilPlacer == null || y >= world.getTopY() - treeHeight - 1) {
            return false;
        }
        for (int checkingY = y; checkingY <= y + 1 + treeHeight; ++checkingY) {
            if (checkingY >= 0 && checkingY < world.getTopY()) {
                int foundBlock = world.method_1776(x, checkingY, z);
                if (foundBlock == 0 || Objects.requireNonNull((class_17)BlockRegistry.INSTANCE.get((int)foundBlock)).field_1900 != class_15.field_987) continue;
                return false;
            }
            return false;
        }
        soilPlacer.placeSoil(world, random, x, y - 1, z);
        int currentLeafRadius = this.topLeafRadiusGetter.provide(random);
        int minLeafRadius = this.minLeafRadiusGetter.provide(random);
        int nextLoopedRadius = this.radiusAfterTopLeafGetter.provide(random);
        int topLeafHeight = this.topLeafHeightGetter.provide(random);
        int trunkHeight = treeHeight - topLeafHeight;
        int maxLeafRadius = this.maxLeafRadiusGetter.provide(random);
        int treeTrunkReduction = this.trunkReductionGetter.provide(random);
        int leavesConsiderdAfterTop = this.leavesConsideredAfterTopGetter.provide(random);
        int leavesSoFar = 0;
        for (relativeY = 0; relativeY < treeHeight - treeTrunkReduction; ++relativeY) {
            if (!TreeGenHelpers.isReplaceableByLogs(world.getBlockState(x, y + relativeY, z))) continue;
            world.method_154(x, y + relativeY, z, this.trunk.field_1915, 1);
        }
        for (relativeY = 0; relativeY <= trunkHeight; ++relativeY) {
            int placingY = y + treeHeight - relativeY;
            for (int relativeX = x - currentLeafRadius; relativeX <= x + currentLeafRadius; ++relativeX) {
                int placingX = relativeX - x;
                for (int relativeZ = z - currentLeafRadius; relativeZ <= z + currentLeafRadius; ++relativeZ) {
                    int placingZ = relativeZ - z;
                    if (Math.abs(placingX) == currentLeafRadius && Math.abs(placingZ) == currentLeafRadius && currentLeafRadius > 0 || class_17.field_1939[world.method_1776(relativeX, placingY, relativeZ)]) continue;
                    world.method_200(relativeX, placingY, relativeZ, this.leaves.field_1915);
                }
            }
            if (currentLeafRadius >= minLeafRadius) {
                currentLeafRadius = nextLoopedRadius;
                if (leavesConsiderdAfterTop <= leavesSoFar) {
                    nextLoopedRadius = 1;
                }
                if (++minLeafRadius <= maxLeafRadius) continue;
                minLeafRadius = maxLeafRadius;
                continue;
            }
            ++currentLeafRadius;
        }
        TreeGenHelpers.updateGeneratedLeaves(world, x, y + treeHeight, z);
        return true;
    }

    @Override
    public Set<class_17> getSoils() {
        return this.soils.keySet();
    }

    @Generated
    public ConifersGen(class_17 trunk, class_17 leaves, RandomIntProvider treeHeightGetter, RandomIntProvider topLeafHeightGetter, RandomIntProvider maxLeafRadiusGetter, RandomIntProvider trunkReductionGetter, RandomIntProvider topLeafRadiusGetter, RandomIntProvider radiusAfterTopLeafGetter, RandomIntProvider leavesConsideredAfterTopGetter, RandomIntProvider minLeafRadiusGetter, Map<class_17, CustomSoilPlacer> soils) {
        this.trunk = trunk;
        this.leaves = leaves;
        this.treeHeightGetter = treeHeightGetter;
        this.topLeafHeightGetter = topLeafHeightGetter;
        this.maxLeafRadiusGetter = maxLeafRadiusGetter;
        this.trunkReductionGetter = trunkReductionGetter;
        this.topLeafRadiusGetter = topLeafRadiusGetter;
        this.radiusAfterTopLeafGetter = radiusAfterTopLeafGetter;
        this.leavesConsideredAfterTopGetter = leavesConsideredAfterTopGetter;
        this.minLeafRadiusGetter = minLeafRadiusGetter;
        this.soils = soils;
    }
}

