/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.forested.worldgen.tree;

import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import lombok.Generated;
import net.glasslauncher.mods.forested.util.RandomIntProvider;
import net.glasslauncher.mods.forested.worldgen.tree.CustomSoilPlacer;
import net.glasslauncher.mods.forested.worldgen.tree.ForestedTreeFeature;
import net.glasslauncher.mods.forested.worldgen.tree.TreeGenHelpers;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_239;
import net.modificationstation.stationapi.api.registry.BlockRegistry;

public class ThickOakGen
extends class_239
implements ForestedTreeFeature {
    protected final class_17 trunk;
    protected final class_17 leaves;
    protected final RandomIntProvider treeHeightGetter;
    protected final BiFunction<Random, Integer, Integer> leafRadiusShrinkGetter;
    protected final RandomIntProvider leafLayerCountGetter;
    protected final RandomIntProvider stumpHeight;
    protected final Map<class_17, CustomSoilPlacer> soils;

    public ThickOakGen(class_17 trunk, class_17 leaves, RandomIntProvider treeHeightGetter, BiFunction<Random, Integer, Integer> leafRadiusShrinkGetter, RandomIntProvider leafLayerCountGetter, RandomIntProvider stumpHeight) {
        this.trunk = trunk;
        this.leaves = leaves;
        this.treeHeightGetter = treeHeightGetter;
        this.leafRadiusShrinkGetter = leafRadiusShrinkGetter;
        this.leafLayerCountGetter = leafLayerCountGetter;
        this.stumpHeight = stumpHeight;
        this.soils = TreeGenHelpers.DEFAULT_SOILS;
    }

    @Override
    public boolean method_1142(class_18 world, Random random, int x, int y, int z) {
        int treeHeight = this.treeHeightGetter.provide(random);
        if (y + treeHeight + 1 > world.getTopY()) {
            return false;
        }
        int supportingBlockId = world.method_1776(x, y - 1, z);
        CustomSoilPlacer soilPlacer = this.soils.get(BlockRegistry.INSTANCE.getOrThrow(supportingBlockId));
        if (soilPlacer == null || y >= world.getTopY() - treeHeight - 1) {
            return false;
        }
        for (int checkingY = y; checkingY <= y + 1 + treeHeight; ++checkingY) {
            if (checkingY < world.getTopY()) {
                int foundBlockId = world.method_1776(x, checkingY, z);
                if (foundBlockId == 0 || Objects.requireNonNull((class_17)BlockRegistry.INSTANCE.get((int)foundBlockId)).field_1900 != class_15.field_987) continue;
                return false;
            }
            return false;
        }
        soilPlacer.placeSoil(world, random, x, y - 1, z);
        this.placeLogs(world, x, y, z, treeHeight);
        this.placeLogs(world, x - 1, y, z, this.stumpHeight.provide(random));
        this.placeLogs(world, x + 1, y, z, this.stumpHeight.provide(random));
        this.placeLogs(world, x, y, z - 1, this.stumpHeight.provide(random));
        this.placeLogs(world, x, y, z + 1, this.stumpHeight.provide(random));
        for (int placingY = y - this.leafLayerCountGetter.provide(random) + treeHeight; placingY <= y + treeHeight; ++placingY) {
            int leafLayer = placingY - (y + treeHeight);
            int leafRadiusShrink = this.leafRadiusShrinkGetter.apply(random, leafLayer);
            for (int placingX = x - leafRadiusShrink; placingX <= x + leafRadiusShrink; ++placingX) {
                int mirroredX = placingX - x;
                for (int placingZ = z - leafRadiusShrink; placingZ <= z + leafRadiusShrink; ++placingZ) {
                    int mirroredZ = placingZ - z;
                    if (Math.abs(mirroredX) == leafRadiusShrink && Math.abs(mirroredZ) == leafRadiusShrink && (random.nextInt(2) == 0 || leafLayer == 0) || class_17.field_1939[world.method_1776(placingX, placingY, placingZ)]) continue;
                    world.method_200(placingX, placingY, placingZ, this.leaves.field_1915);
                }
            }
        }
        TreeGenHelpers.updateGeneratedLeaves(world, x, y + treeHeight, z);
        return true;
    }

    private void placeLogs(class_18 world, int x, int y, int z, int height) {
        for (int relativeY = 0; relativeY < height; ++relativeY) {
            if (!TreeGenHelpers.isReplaceableByLogs(world.getBlockState(x, y + relativeY, z))) continue;
            world.method_200(x, y + relativeY, z, this.trunk.field_1915);
        }
    }

    @Override
    public Set<class_17> getSoils() {
        return this.soils.keySet();
    }

    @Generated
    public ThickOakGen(class_17 trunk, class_17 leaves, RandomIntProvider treeHeightGetter, BiFunction<Random, Integer, Integer> leafRadiusShrinkGetter, RandomIntProvider leafLayerCountGetter, RandomIntProvider stumpHeight, Map<class_17, CustomSoilPlacer> soils) {
        this.trunk = trunk;
        this.leaves = leaves;
        this.treeHeightGetter = treeHeightGetter;
        this.leafRadiusShrinkGetter = leafRadiusShrinkGetter;
        this.leafLayerCountGetter = leafLayerCountGetter;
        this.stumpHeight = stumpHeight;
        this.soils = soils;
    }
}

