/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.forested.worldgen.tree;

import java.util.List;
import java.util.Map;
import net.glasslauncher.mods.forested.blocks.ForestedBlocks;
import net.glasslauncher.mods.forested.blocks.ForestedLeavesBlock;
import net.glasslauncher.mods.forested.blocks.ForestedLogBlock;
import net.glasslauncher.mods.forested.blocks.ForestedSaplingBlock;
import net.glasslauncher.mods.forested.worldgen.tree.AlternateOakGen;
import net.glasslauncher.mods.forested.worldgen.tree.CherryGen;
import net.glasslauncher.mods.forested.worldgen.tree.ConifersGen;
import net.glasslauncher.mods.forested.worldgen.tree.ForestedTreeFeature;
import net.glasslauncher.mods.forested.worldgen.tree.ThickOakGen;
import net.glasslauncher.mods.forested.worldgen.tree.WillowGen;
import net.minecraft.class_153;
import net.minecraft.class_17;

public enum TreeType {
    ACACIA(ForestedBlocks.Wood.acacia, ForestedBlocks.Leaves.acacia, ForestedBlocks.Sapling.acacia, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 5, (random, layer) -> layer == 0 ? 1 : -layer.intValue() * 2, r -> 2), () -> List.of(class_153.field_879)),
    BALSA(ForestedBlocks.Wood.balsa, ForestedBlocks.Leaves.balsa, ForestedBlocks.Sapling.balsa, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(2) + 7, (random, layer) -> layer == 0 ? 1 : -((int)Math.floor((double)layer.intValue() * 1.5)), r -> 2), () -> List.of(class_153.field_875)),
    BAOBAB(ForestedBlocks.Wood.baobab, ForestedBlocks.Leaves.baobab, ForestedBlocks.Sapling.baobab, (t, l) -> new ThickOakGen((class_17)t, (class_17)l, r -> r.nextInt(2) + 8, (random, layer) -> layer == 0 ? 1 : -layer.intValue() + 1, r -> 2, r -> 8 + r.nextInt(1), Map.of(class_17.field_1826, (w, r, x, y, z) -> {})), () -> List.of(class_153.field_879)),
    CHERRY(ForestedBlocks.Wood.cherry, ForestedBlocks.Leaves.cherry, ForestedBlocks.Sapling.cherry, (t, l) -> new CherryGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 5, (random, layer) -> layer == 0 ? 1 : -((int)Math.floor((double)layer.intValue() * 1.5)), r -> 2, r -> r.nextInt(3) + 1, r -> r.nextInt(3), (r, treeHeight) -> treeHeight - 2 - r.nextInt(2)), () -> List.of(class_153.field_878)),
    CHESTNUT(ForestedBlocks.Wood.chestnut, ForestedBlocks.Leaves.chestnut, ForestedBlocks.Sapling.chestnut, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 4, (random, layer) -> 1 - layer / 2, r -> 3), () -> List.of(class_153.field_878)),
    CITRUS(ForestedBlocks.Wood.citrus, ForestedBlocks.Leaves.citrus, ForestedBlocks.Sapling.citrus, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 5, (random, layer) -> layer == 0 ? 1 : -((int)Math.floor((double)layer.intValue() / 2.0)), r -> 4), () -> List.of(class_153.field_877)),
    COCOBOLO(ForestedBlocks.Wood.cocobolo, ForestedBlocks.Leaves.cocobolo, ForestedBlocks.Sapling.cocobolo, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 7, (random, layer) -> 1, r -> 4 + r.nextInt(3)), () -> List.of(class_153.field_875)),
    EBONY(ForestedBlocks.Wood.ebony, ForestedBlocks.Leaves.ebony, ForestedBlocks.Sapling.ebony, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 4, (random, layer) -> 1 - layer / 2, r -> 3), () -> List.of(class_153.field_875)),
    GIGANTEUM(ForestedBlocks.Wood.giganteum, ForestedBlocks.Leaves.giganteum, ForestedBlocks.Sapling.giganteum, (t, l) -> new ThickOakGen((class_17)t, (class_17)l, r -> r.nextInt(8) + 20, (random, layer) -> layer == 0 ? 2 : 2 + random.nextInt(2), r -> r.nextInt(2) + 6, r -> 19 + r.nextInt(2)), List::of),
    GREENHEART(ForestedBlocks.Wood.greenheart, ForestedBlocks.Leaves.greenheart, ForestedBlocks.Sapling.greenheart, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 4, (random, layer) -> 1 - layer / 2, r -> 3), () -> List.of(class_153.field_875, class_153.field_877)),
    IPE(ForestedBlocks.Wood.ipe, ForestedBlocks.Leaves.ipe, ForestedBlocks.Sapling.ipe, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 6, (random, layer) -> 2 - layer / 2, r -> 3), () -> List.of(class_153.field_875)),
    IRONWOOD(ForestedBlocks.Wood.ironwood, ForestedBlocks.Leaves.ironwood, ForestedBlocks.Sapling.ironwood, (t, l) -> new CherryGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 3, (random, layer) -> 2 - layer / 2, r -> 3, r -> r.nextInt(4) + 2, r -> r.nextInt(2) + 1, (r, treeHeight) -> treeHeight > 0 ? treeHeight - 1 - r.nextInt(treeHeight / 2) : treeHeight - 1, Map.of(class_17.field_1826, (w, r, x, y, z) -> {})), () -> List.of(class_153.field_882)),
    KAPOK(ForestedBlocks.Wood.kapok, ForestedBlocks.Leaves.kapok, ForestedBlocks.Sapling.kapok, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(2) + 8, (random, layer) -> layer == 0 ? 1 : -layer.intValue() + 1, r -> 2), () -> List.of(class_153.field_875)),
    LARCH(ForestedBlocks.Wood.larch, ForestedBlocks.Leaves.larch, ForestedBlocks.Sapling.larch, (t, l) -> new ConifersGen((class_17)t, (class_17)l, r -> 6 + r.nextInt(2), r -> 2, r -> r.nextInt(2) + 1, r -> r.nextInt(3), r -> 0, r -> 0, r -> 1, r -> 1), () -> List.of(class_153.field_881)),
    LIME(ForestedBlocks.Wood.lime, ForestedBlocks.Leaves.lime, ForestedBlocks.Sapling.lime, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 5, (random, layer) -> layer == 0 ? 1 : -((int)Math.floor((double)layer.intValue() / 2.0)), r -> 4), () -> List.of(class_153.field_875)),
    MAHOE(ForestedBlocks.Wood.mahoe, ForestedBlocks.Leaves.mahoe, ForestedBlocks.Sapling.mahoe, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 5, (random, layer) -> layer == 0 ? 1 : -((int)Math.floor((double)layer.intValue() / 2.0)), r -> 4), () -> List.of(class_153.field_875, class_153.field_877)),
    MAHOGANY(ForestedBlocks.Wood.mahogany, ForestedBlocks.Leaves.mahogany, ForestedBlocks.Sapling.mahogany, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 6, (random, layer) -> 2 - layer / 2, r -> 3), () -> List.of(class_153.field_875, class_153.field_877)),
    MAPLE(ForestedBlocks.Wood.maple, ForestedBlocks.Leaves.maple, ForestedBlocks.Sapling.maple, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 5, (random, layer) -> 2 - layer / 2, r -> 3), () -> List.of(class_153.field_878, class_153.field_883)),
    PADAUK(ForestedBlocks.Wood.padauk, ForestedBlocks.Leaves.padauk, ForestedBlocks.Sapling.padauk, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 5, (random, layer) -> 2 - layer / 2, r -> 3), () -> List.of(class_153.field_875)),
    PALM(ForestedBlocks.Wood.palm, ForestedBlocks.Leaves.palm, ForestedBlocks.Sapling.palm, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 5, (random, layer) -> 3 + layer, r -> 2, Map.of(class_17.field_1826, (w, r, x, y, z) -> {})), () -> List.of(class_153.field_882)),
    PAPAYA(ForestedBlocks.Wood.papaya, ForestedBlocks.Leaves.papaya, ForestedBlocks.Sapling.papaya, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 5, (random, layer) -> layer == 0 ? 1 : (layer == -1 ? 2 : 1), r -> 2), () -> List.of(class_153.field_875)),
    PINE(ForestedBlocks.Wood.pine, ForestedBlocks.Leaves.pine, ForestedBlocks.Sapling.pine, (t, l) -> new ConifersGen((class_17)t, (class_17)l, r -> 6 + r.nextInt(2), r -> 2, r -> r.nextInt(2) + 1, r -> r.nextInt(3), r -> 0, r -> 0, r -> 1, r -> 1), () -> List.of(class_153.field_881)),
    PLUM(ForestedBlocks.Wood.plum, ForestedBlocks.Leaves.plum, ForestedBlocks.Sapling.plum, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 4, (random, layer) -> 1 - layer / 2, r -> 3), () -> List.of(class_153.field_876)),
    POPLAR(ForestedBlocks.Wood.poplar, ForestedBlocks.Leaves.poplar, ForestedBlocks.Sapling.poplar, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(4) + 9, (random, layer) -> 1, r -> 4 + r.nextInt(3)), () -> List.of(class_153.field_878)),
    SEQUOIA(ForestedBlocks.Wood.sequoia, ForestedBlocks.Leaves.sequoia, ForestedBlocks.Sapling.sequoia, (t, l) -> new ThickOakGen((class_17)t, (class_17)l, r -> r.nextInt(5) + 12, (random, layer) -> layer == 0 ? 2 : 2 + random.nextInt(2), r -> r.nextInt(2) + 6, r -> 11 + r.nextInt(2)), List::of),
    TEAK(ForestedBlocks.Wood.teak, ForestedBlocks.Leaves.teak, ForestedBlocks.Sapling.teak, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 7, (random, layer) -> layer == 0 ? 1 : -((int)Math.floor((double)layer.intValue() / 2.0)), r -> 4), () -> List.of(class_153.field_875)),
    WALNUT(ForestedBlocks.Wood.walnut, ForestedBlocks.Leaves.walnut, ForestedBlocks.Sapling.walnut, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 4, (random, layer) -> 2 - layer / 2, r -> 3), () -> List.of(class_153.field_878)),
    WENGE(ForestedBlocks.Wood.wenge, ForestedBlocks.Leaves.wenge, ForestedBlocks.Sapling.wenge, (t, l) -> new AlternateOakGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 4, (random, layer) -> 1 - layer / 2, r -> 3), () -> List.of(class_153.field_875, class_153.field_879)),
    WILLOW(ForestedBlocks.Wood.willow, ForestedBlocks.Leaves.willow, ForestedBlocks.Sapling.willow, (t, l) -> new WillowGen((class_17)t, (class_17)l, r -> r.nextInt(3) + 5, (random, layer) -> 2 - layer / 2, r -> 3, r -> r.nextInt(3)), () -> List.of(class_153.field_876)),
    ZEBRAWOOD(ForestedBlocks.Wood.zebrawood, ForestedBlocks.Leaves.zebrawood, ForestedBlocks.Sapling.zebrawood, (t, l) -> new CherryGen((class_17)t, (class_17)l, r -> r.nextInt(6) + 8, (random, layer) -> 2 - layer / 2, r -> 3, r -> r.nextInt(4) + 2, r -> r.nextInt(2) + 2, (r, treeHeight) -> treeHeight - 2 - r.nextInt(4)), () -> List.of(class_153.field_879));

    public final ForestedLogBlock trunk;
    public final ForestedLeavesBlock leaves;
    public final ForestedSaplingBlock sapling;
    public final LazyBiomeProvider biomeProvider;
    public final ForestedTreeFeature feature;

    private TreeType(ForestedLogBlock trunk, ForestedLeavesBlock leaves, ForestedSaplingBlock sapling, LazyTreeFeatureProvider treeFeatureProvider, LazyBiomeProvider biomes) {
        this.trunk = trunk;
        this.leaves = leaves;
        this.sapling = sapling;
        this.biomeProvider = biomes;
        this.feature = treeFeatureProvider.provide(trunk, leaves);
    }

    @FunctionalInterface
    public static interface LazyBiomeProvider {
        public List<class_153> getBiomes();
    }

    @FunctionalInterface
    public static interface LazyTreeFeatureProvider {
        public ForestedTreeFeature provide(ForestedLogBlock var1, ForestedLeavesBlock var2);
    }
}

