/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.landscaped.blocks;

import java.util.Random;
import net.minecraft.class_127;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.block.States;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.registry.tag.BlockTags;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.BooleanProperty;
import net.modificationstation.stationapi.api.state.property.IntProperty;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;

public class LeavesBlockTemplate
extends TemplateBlock {
    public static final IntProperty DISTANCE = IntProperty.of((String)"distance", (int)0, (int)8);
    public static final BooleanProperty PERSISTENT = BooleanProperty.of((String)"persistent");
    public int maxDistance = 7;
    public int fastTextureId = 1;

    public LeavesBlockTemplate(Identifier identifier) {
        super(identifier, class_15.field_987);
        this.method_1584(true);
        this.setDefaultState((BlockState)((BlockState)this.getDefaultState().with((Property)DISTANCE, (Comparable)Integer.valueOf(0))).with((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getPlacementState(ItemPlacementContext context) {
        return (BlockState)this.getDefaultState().with((Property)PERSISTENT, (Comparable)Boolean.valueOf(true));
    }

    public void method_1614(class_18 world, int x, int y, int z, class_127 placer) {
        this.updateDecay(world, x, y, z, false);
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(new Property[]{DISTANCE});
        builder.add(new Property[]{PERSISTENT});
    }

    public void method_1609(class_18 world, int x, int y, int z, int id) {
        super.method_1609(world, x, y, z, id);
        if (!world.field_180) {
            this.updateDecay(world, x, y, z, false);
        }
    }

    public void method_1602(class_18 world, int x, int y, int z, Random random) {
        super.method_1602(world, x, y, z, random);
        if (!world.field_180) {
            this.updateDecay(world, x, y, z, true);
        }
    }

    public void updateDecay(class_18 world, int x, int y, int z, boolean decay) {
        Direction direction;
        BlockState state = world.getBlockState(x, y, z);
        if (((Boolean)state.get((Property)PERSISTENT)).booleanValue()) {
            return;
        }
        int distance = this.maxDistance + 1;
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; i < n && (distance = Math.min(distance, this.getDistance(world, x + (direction = directionArray[i]).getOffsetX(), y + direction.getOffsetY(), z + direction.getOffsetZ()) + 1)) != 1; ++i) {
        }
        if (decay && distance > this.maxDistance) {
            this.decay(world, x, y, z);
            return;
        }
        int prevDistance = (Integer)state.get((Property)DISTANCE);
        if (distance != prevDistance) {
            world.setBlockState(x, y, z, (BlockState)state.with((Property)DISTANCE, (Comparable)Integer.valueOf(distance)));
            for (Direction side : Direction.values()) {
                if (!world.getBlockState(x + side.getOffsetX(), y + side.getOffsetY(), z + side.getOffsetZ()).contains((Property)DISTANCE)) continue;
                this.updateDecay(world, x + side.getOffsetX(), y + side.getOffsetY(), z + side.getOffsetZ(), false);
            }
        }
    }

    public int getDistance(class_18 world, int x, int y, int z) {
        BlockState state = world.getBlockState(x, y, z);
        if (state.isIn(BlockTags.LOGS)) {
            return 0;
        }
        if (state.contains((Property)DISTANCE)) {
            return (Integer)state.get((Property)DISTANCE);
        }
        return this.maxDistance;
    }

    public void decay(class_18 world, int x, int y, int z) {
        int meta = world.method_1778(x, y, z);
        world.setBlockStateWithNotify(x, y, z, (BlockState)States.AIR.get());
        this.method_1592(world, x, y, z, meta);
    }

    public boolean method_1620() {
        return class_17.field_1832.method_1620();
    }

    public boolean method_1618(class_14 blockView, int x, int y, int z, int side) {
        int foundBlockId = blockView.method_1776(x, y, z);
        if (class_17.field_1832.method_1620() && foundBlockId == this.field_1915) {
            return false;
        }
        if (side == 0 && this.field_1921 > 0.0) {
            return true;
        }
        if (side == 1 && this.field_1924 < 1.0) {
            return true;
        }
        if (side == 2 && this.field_1922 > 0.0) {
            return true;
        }
        if (side == 3 && this.field_1925 < 1.0) {
            return true;
        }
        if (side == 4 && this.field_1920 > 0.0) {
            return true;
        }
        return side == 5 && this.field_1923 < 1.0 || !blockView.method_1783(x, y, z);
    }

    public int method_1626(class_14 blockView, int x, int y, int z, int side) {
        return class_17.field_1832.method_1620() ? this.fastTextureId : this.field_1914;
    }

    public int method_1603(Random random) {
        return random.nextInt(20) == 0 ? 1 : 0;
    }
}

