/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.api.gcapi.impl.config.entry;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.glasslauncher.mods.api.gcapi.api.HasDrawable;
import net.glasslauncher.mods.api.gcapi.api.MaxLength;
import net.glasslauncher.mods.api.gcapi.impl.config.ConfigEntry;
import net.glasslauncher.mods.api.gcapi.screen.widget.ExtensibleTextbox;
import net.glasslauncher.mods.api.gcapi.screen.widget.Icon;
import net.minecraft.class_32;
import net.minecraft.class_34;
import org.jetbrains.annotations.NotNull;

public class StringConfigEntry
extends ConfigEntry<String> {
    private ExtensibleTextbox textbox;
    private List<HasDrawable> drawableList;

    public StringConfigEntry(String id, String name, String description, Field parentField, Object parentObject, boolean isMultiplayerSynced, String value, MaxLength maxLength) {
        super(id, name, description, parentField, parentObject, isMultiplayerSynced, value, maxLength);
        this.maxLength = maxLength;
    }

    @Override
    public void init(class_32 parent, class_34 textRenderer) {
        this.textbox = new ExtensibleTextbox(textRenderer);
        this.textbox.setMaxLength(this.maxLength.value());
        this.textbox.setText((String)this.value);
        this.textbox.setEnabled(!this.multiplayerLoaded);
        this.drawableList = new ArrayList<HasDrawable>(){
            {
                this.add(StringConfigEntry.this.textbox);
            }
        };
        if (this.multiplayerSynced) {
            this.drawableList.add(new Icon(10, 0, 0, 0, "/assets/gcapi/server_synced.png"));
        }
    }

    @Override
    public String getDrawableValue() {
        return this.textbox == null ? null : this.textbox.getText();
    }

    @Override
    public void setDrawableValue(String value) {
        this.textbox.setText(value);
    }

    @Override
    public boolean isValueValid() {
        return this.textbox.isValueValid();
    }

    @Override
    @NotNull
    public List<HasDrawable> getDrawables() {
        return this.drawableList;
    }
}

