/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.api.gcapi.impl.config.entry;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.glasslauncher.mods.api.gcapi.api.CharacterUtils;
import net.glasslauncher.mods.api.gcapi.api.HasDrawable;
import net.glasslauncher.mods.api.gcapi.api.MaxLength;
import net.glasslauncher.mods.api.gcapi.impl.config.ConfigEntry;
import net.glasslauncher.mods.api.gcapi.screen.widget.ExtensibleTextbox;
import net.glasslauncher.mods.api.gcapi.screen.widget.Icon;
import net.minecraft.class_32;
import net.minecraft.class_34;
import org.jetbrains.annotations.NotNull;
import uk.co.benjiweber.expressions.tuple.BiTuple;

public class FloatConfigEntry
extends ConfigEntry<Float> {
    private ExtensibleTextbox textbox;
    private List<HasDrawable> drawableList;

    public FloatConfigEntry(String id, String name, String description, Field parentField, Object parentObject, boolean isMultiplayerSynced, Float value, MaxLength maxLength) {
        super(id, name, description, parentField, parentObject, isMultiplayerSynced, value, maxLength);
    }

    @Override
    public void init(class_32 parent, class_34 textRenderer) {
        this.textbox = new ExtensibleTextbox(textRenderer);
        this.textbox.setValidator(str -> BiTuple.of((Object)(CharacterUtils.isFloat(str) && Float.parseFloat(str) <= (float)this.maxLength.value() ? 1 : 0), this.multiplayerLoaded ? Collections.singletonList("Server synced, you cannot change this value") : (CharacterUtils.isFloat(str) ? (Float.parseFloat(str) > (float)this.maxLength.value() ? Collections.singletonList("Value is too high") : null) : Collections.singletonList("Value is not a decimal number"))));
        this.textbox.setMaxLength(this.maxLength.value());
        this.textbox.setText(((Float)this.value).toString());
        this.textbox.setEnabled(!this.multiplayerLoaded);
        this.drawableList = new ArrayList<HasDrawable>(){
            {
                this.add(FloatConfigEntry.this.textbox);
            }
        };
        if (this.multiplayerSynced) {
            this.drawableList.add(new Icon(10, 0, 0, 0, "/assets/gcapi/server_synced.png"));
        }
    }

    @Override
    public Float getDrawableValue() {
        return this.textbox == null ? null : Float.valueOf(Float.parseFloat(this.textbox.getText()));
    }

    @Override
    public void setDrawableValue(Float value) {
        this.textbox.setText(value.toString());
    }

    @Override
    public boolean isValueValid() {
        return this.textbox.isValueValid();
    }

    @Override
    @NotNull
    public List<HasDrawable> getDrawables() {
        return this.drawableList;
    }
}

