/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.api.gcapi.impl.config.entry;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.glasslauncher.mods.api.gcapi.api.CharacterUtils;
import net.glasslauncher.mods.api.gcapi.api.HasDrawable;
import net.glasslauncher.mods.api.gcapi.api.MaxLength;
import net.glasslauncher.mods.api.gcapi.impl.config.ConfigEntry;
import net.glasslauncher.mods.api.gcapi.screen.widget.ExtensibleTextFieldWidget;
import net.glasslauncher.mods.api.gcapi.screen.widget.IconWidget;
import net.minecraft.class_32;
import net.minecraft.class_34;
import org.jetbrains.annotations.NotNull;
import uk.co.benjiweber.expressions.tuple.BiTuple;

public class IntegerConfigEntry
extends ConfigEntry<Integer> {
    private ExtensibleTextFieldWidget textbox;
    private List<HasDrawable> drawableList;

    public IntegerConfigEntry(String id, String name, String description, Field parentField, Object parentObject, boolean multiplayerSynced, Integer value, MaxLength maxLength) {
        super(id, name, description, parentField, parentObject, multiplayerSynced, value, maxLength);
    }

    @Override
    public void init(class_32 parent, class_34 textRenderer) {
        this.textbox = new ExtensibleTextFieldWidget(textRenderer);
        this.textbox.setValidator(str -> BiTuple.of((Object)(CharacterUtils.isInteger(str) && Integer.parseInt(str) <= this.maxLength.value() ? 1 : 0), this.multiplayerLoaded ? Collections.singletonList("Server synced, you cannot change this value") : (CharacterUtils.isFloat(str) ? (Float.parseFloat(str) > (float)this.maxLength.value() ? Collections.singletonList("Value is too high") : null) : Collections.singletonList("Value is not a whole number"))));
        this.textbox.setMaxLength(this.maxLength.value());
        this.textbox.setText(((Integer)this.value).toString());
        this.textbox.setEnabled(!this.multiplayerLoaded);
        this.drawableList = new ArrayList<HasDrawable>(){
            {
                this.add(IntegerConfigEntry.this.textbox);
            }
        };
        if (this.multiplayerSynced) {
            this.drawableList.add(new IconWidget(10, 0, 0, 0, "/assets/gcapi/server_synced.png"));
        }
    }

    @Override
    public Integer getDrawableValue() {
        return this.textbox == null ? null : Integer.valueOf(Integer.parseInt(this.textbox.getText()));
    }

    @Override
    public void setDrawableValue(Integer value) {
        this.textbox.setText(value.toString());
    }

    @Override
    public boolean isValueValid() {
        return this.textbox.isValueValid();
    }

    @Override
    @NotNull
    public List<HasDrawable> getDrawables() {
        return this.drawableList;
    }
}

