/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.api.gcapi.impl;

import blue.endless.jankson.Comment;
import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.glasslauncher.mods.api.gcapi.api.ConfigFactoryProvider;
import net.glasslauncher.mods.api.gcapi.api.ConfigName;
import net.glasslauncher.mods.api.gcapi.api.GConfig;
import net.glasslauncher.mods.api.gcapi.api.MaxLength;
import net.glasslauncher.mods.api.gcapi.api.MultiplayerSynced;
import net.glasslauncher.mods.api.gcapi.api.PostConfigLoadedListener;
import net.glasslauncher.mods.api.gcapi.api.PreConfigSavedListener;
import net.glasslauncher.mods.api.gcapi.impl.ConfigFactories;
import net.glasslauncher.mods.api.gcapi.impl.EventStorage;
import net.glasslauncher.mods.api.gcapi.impl.config.ConfigBase;
import net.glasslauncher.mods.api.gcapi.impl.config.ConfigCategory;
import net.glasslauncher.mods.api.gcapi.impl.config.ConfigEntry;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.ReflectionHelper;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import uk.co.benjiweber.expressions.function.OctFunction;
import uk.co.benjiweber.expressions.tuple.BiTuple;

@Deprecated
public class GCCore
implements PreLaunchEntrypoint {
    public static final ModContainer NAMESPACE = (ModContainer)FabricLoader.getInstance().getModContainer("gcapi").orElseThrow(RuntimeException::new);
    public static final HashMap<Identifier, BiTuple<EntrypointContainer<Object>, ConfigCategory>> MOD_CONFIGS = new HashMap();
    private static boolean loaded = false;
    private static final Logger LOGGER = LogManager.getFormatterLogger((String)"GCAPI");
    private static final Supplier<MaxLength> MAX_LENGTH_SUPPLIER = () -> new MaxLength(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return MaxLength.class;
        }

        @Override
        public int value() {
            return 32;
        }

        @Override
        public int arrayValue() {
            return -1;
        }

        @Override
        public boolean fixedArray() {
            return false;
        }
    };

    public static void loadServerConfig(String modID, String string) {
        AtomicReference mod = new AtomicReference();
        MOD_CONFIGS.keySet().forEach(modContainer -> {
            if (modContainer.toString().equals(modID)) {
                mod.set(modContainer);
            }
        });
        if (mod.get() != null) {
            BiTuple<EntrypointContainer<Object>, ConfigCategory> category = MOD_CONFIGS.get(mod.get());
            GCCore.saveConfig((EntrypointContainer<Object>)((EntrypointContainer)category.one()), (ConfigCategory)category.two());
            try {
                GCCore.loadModConfig(((EntrypointContainer)category.one()).getEntrypoint(), ((EntrypointContainer)category.one()).getProvider(), ((ConfigCategory)category.two()).parentField, (Identifier)mod.get(), Jankson.builder().build().load(string));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void exportConfigsForServer(class_8 nbtCompound) {
        for (Identifier modContainer : MOD_CONFIGS.keySet()) {
            BiTuple<EntrypointContainer<Object>, ConfigCategory> entry = MOD_CONFIGS.get(modContainer);
            nbtCompound.method_1019(modContainer.toString(), GCCore.saveConfig((EntrypointContainer<Object>)((EntrypointContainer)entry.one()), (ConfigCategory)entry.two()));
        }
    }

    public void onPreLaunch() {
        GCCore.loadConfigs();
    }

    public static void log(String message) {
        LOGGER.info(message);
    }

    public static void log(Level level, String message) {
        LOGGER.log(level, message);
    }

    private static void loadConfigs() {
        if (loaded) {
            GCCore.log(Level.WARN, "Tried to load configs a second time! Printing stacktrace and aborting!");
            new Exception("Stacktrace for duplicate loadConfigs call!").printStackTrace();
            return;
        }
        GCCore.log("Loading config factories.");
        List containers = FabricLoader.getInstance().getEntrypointContainers("gcapi:factory_provider", ConfigFactoryProvider.class);
        ImmutableMap.Builder loadImmutableBuilder = ImmutableMap.builder();
        containers.forEach(customConfigFactoryProviderEntrypointContainer -> ((ConfigFactoryProvider)customConfigFactoryProviderEntrypointContainer.getEntrypoint()).provideLoadFactories(loadImmutableBuilder));
        ConfigFactories.loadFactories = loadImmutableBuilder.build();
        GCCore.log(ConfigFactories.loadFactories.size() + " config load factories loaded.");
        ImmutableMap.Builder saveImmutableBuilder = ImmutableMap.builder();
        containers.forEach(customConfigFactoryProviderEntrypointContainer -> ((ConfigFactoryProvider)customConfigFactoryProviderEntrypointContainer.getEntrypoint()).provideSaveFactories((ImmutableMap.Builder<Type, Function<Object, JsonElement>>)saveImmutableBuilder));
        ConfigFactories.saveFactories = saveImmutableBuilder.build();
        GCCore.log(ConfigFactories.saveFactories.size() + " config save factories loaded.");
        GCCore.log("Loading config event listeners.");
        EventStorage.loadListeners();
        GCCore.log("Loaded config event listeners.");
        FabricLoader.getInstance().getEntrypointContainers(NAMESPACE.getMetadata().getId(), Object.class).forEach(entrypointContainer -> {
            try {
                for (Field field : ReflectionHelper.getFieldsWithAnnotation(entrypointContainer.getEntrypoint().getClass(), GConfig.class)) {
                    Identifier configID = Identifier.of((String)(entrypointContainer.getProvider().getMetadata().getId() + ":" + field.getAnnotation(GConfig.class).value()));
                    MOD_CONFIGS.put(configID, (BiTuple<EntrypointContainer<Object>, ConfigCategory>)BiTuple.of((Object)entrypointContainer, null));
                    GCCore.loadModConfig(entrypointContainer.getEntrypoint(), entrypointContainer.getProvider(), field, configID, null);
                    GCCore.saveConfig((EntrypointContainer<Object>)entrypointContainer, (ConfigCategory)MOD_CONFIGS.get(configID).two());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (EventStorage.POST_LOAD_LISTENERS.containsKey(entrypointContainer.getProvider().getMetadata().getId())) {
                ((PostConfigLoadedListener)EventStorage.POST_LOAD_LISTENERS.get(entrypointContainer.getProvider().getMetadata().getId()).getEntrypoint()).PostConfigLoaded();
            }
        });
        loaded = true;
    }

    public static void loadModConfig(Object rootConfigObject, ModContainer modContainer, Field configField, Identifier configID, JsonObject jsonOverride) {
        GCCore.log(rootConfigObject.getClass().getName());
        GCCore.log(configField.getName());
        AtomicInteger totalReadCategories = new AtomicInteger();
        AtomicInteger totalReadFields = new AtomicInteger();
        boolean isMultiplayer = false;
        boolean forceNotMultiplayer = false;
        try {
            JsonObject rootJsonObject;
            configField.setAccessible(true);
            Object objField = configField.get(rootConfigObject);
            File modConfigFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), modContainer.getMetadata().getId() + "/" + configField.getAnnotation(GConfig.class).value() + ".json");
            if (jsonOverride == null) {
                rootJsonObject = modConfigFile.exists() ? Jankson.builder().build().load(modConfigFile) : new JsonObject();
            } else {
                rootJsonObject = jsonOverride;
                forceNotMultiplayer = rootJsonObject.getBoolean("forceNotMultiplayer", false);
                if (!forceNotMultiplayer) {
                    isMultiplayer = true;
                    GCCore.log("Loading server config for " + modContainer.getMetadata().getId() + "!");
                } else {
                    GCCore.log("Loading forced mod config for " + modContainer.getMetadata().getId() + "!");
                }
            }
            GCCore.log(Arrays.toString(rootJsonObject.keySet().toArray()));
            ConfigCategory configCategory = new ConfigCategory(modContainer.getMetadata().getId(), configField.getAnnotation(GConfig.class).visibleName(), null, configField, objField, configField.isAnnotationPresent(MultiplayerSynced.class), (Multimap<Class<?>, ConfigBase>)HashMultimap.create(), true);
            GCCore.readDeeper(rootConfigObject, configField, rootJsonObject, configCategory, totalReadFields, totalReadCategories, isMultiplayer, forceNotMultiplayer);
            if (!loaded) {
                MOD_CONFIGS.put(configID, (BiTuple<EntrypointContainer<Object>, ConfigCategory>)BiTuple.of((Object)((EntrypointContainer)MOD_CONFIGS.remove(configID).one()), (Object)configCategory));
            } else {
                ((ConfigCategory)GCCore.MOD_CONFIGS.get((Object)configID).two()).values = configCategory.values;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        GCCore.log("Successfully read \"" + modContainer.getMetadata().getId() + "\"'s mod configs, reading " + totalReadCategories.get() + " categories, and " + totalReadFields.get() + " values.");
    }

    private static void readDeeper(Object rootConfigObject, Field configField, JsonObject rootJsonObject, ConfigCategory category, AtomicInteger totalReadFields, AtomicInteger totalReadCategories, boolean isMultiplayer, boolean forceNotMultiplayer) throws IllegalAccessException {
        totalReadCategories.getAndIncrement();
        configField.setAccessible(true);
        Object objField = configField.get(rootConfigObject);
        for (Field field : objField.getClass().getDeclaredFields()) {
            Object childObjField = field.get(objField);
            if (field.isAnnotationPresent(net.glasslauncher.mods.api.gcapi.api.ConfigCategory.class)) {
                JsonObject jsonCategory = rootJsonObject.getObject(field.getName());
                if (jsonCategory == null) {
                    jsonCategory = new JsonObject();
                    rootJsonObject.put(field.getName(), (JsonElement)jsonCategory);
                }
                ConfigCategory childCategory = new ConfigCategory(field.getName(), field.getAnnotation(net.glasslauncher.mods.api.gcapi.api.ConfigCategory.class).value(), field.isAnnotationPresent(Comment.class) ? field.getAnnotation(Comment.class).value() : null, field, objField, category.multiplayerSynced || field.isAnnotationPresent(MultiplayerSynced.class), (Multimap<Class<?>, ConfigBase>)HashMultimap.create(), false);
                category.values.put(net.glasslauncher.mods.api.gcapi.api.ConfigCategory.class, (Object)childCategory);
                GCCore.readDeeper(objField, field, jsonCategory, childCategory, totalReadFields, totalReadCategories, isMultiplayer, forceNotMultiplayer);
                continue;
            }
            if (!field.isAnnotationPresent(ConfigName.class)) {
                throw new RuntimeException("Config value \"" + field.getType().getName() + ";" + field.getName() + "\" has no ConfigName annotation!");
            }
            OctFunction function = (OctFunction)ConfigFactories.loadFactories.get(field.getType());
            if (function == null) {
                throw new RuntimeException("Config value \"" + field.getType().getName() + ";" + field.getName() + "\" has no config loader for it's type!");
            }
            field.setAccessible(true);
            ConfigEntry configEntry = (ConfigEntry)function.apply((Object)field.getName(), (Object)field.getAnnotation(ConfigName.class).value(), (Object)(field.isAnnotationPresent(Comment.class) ? field.getAnnotation(Comment.class).value() : null), (Object)field, objField, (Object)(category.multiplayerSynced || field.isAnnotationPresent(MultiplayerSynced.class) ? 1 : 0), rootJsonObject.get(field.getType(), field.getName()) != null ? rootJsonObject.get(field.getType(), field.getName()) : childObjField, (Object)(field.isAnnotationPresent(MaxLength.class) ? field.getAnnotation(MaxLength.class) : MAX_LENGTH_SUPPLIER.get()));
            configEntry.multiplayerLoaded = isMultiplayer && configEntry.multiplayerSynced && !forceNotMultiplayer;
            category.values.put(field.getType(), (Object)configEntry);
            field.set(objField, configEntry.value);
            totalReadFields.getAndIncrement();
        }
    }

    public static String saveConfig(EntrypointContainer<Object> container, ConfigCategory category) {
        try {
            AtomicInteger readValues = new AtomicInteger();
            AtomicInteger readCategories = new AtomicInteger();
            File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), container.getProvider().getMetadata().getId() + "/" + category.parentField.getAnnotation(GConfig.class).value() + ".json");
            JsonObject newValues = configFile.exists() ? Jankson.builder().build().load(configFile) : new JsonObject();
            JsonObject serverExported = new JsonObject();
            for (ConfigBase entry : category.values.values()) {
                if (entry instanceof ConfigCategory) {
                    GCCore.log(entry.parentField.getDeclaringClass().getName());
                    GCCore.log(container.getEntrypoint().getClass().getName());
                    BiTuple<JsonObject, JsonObject> values = GCCore.saveDeeper((ConfigCategory)entry, entry.parentField, readValues, readCategories);
                    newValues.put(entry.id, (JsonElement)values.one());
                    serverExported.put(entry.id, (JsonElement)values.two());
                    readCategories.getAndIncrement();
                    continue;
                }
                if (entry instanceof ConfigEntry) {
                    Function configFactory = (Function)ConfigFactories.saveFactories.get(((ConfigEntry)entry).value.getClass());
                    if (configFactory == null) {
                        throw new RuntimeException("Config value \"" + entry.parentObject.getClass().getName() + ";" + entry.id + "\" has no config saver for it's type!");
                    }
                    JsonElement jsonElement = (JsonElement)configFactory.apply(((ConfigEntry)entry).value);
                    if (!((ConfigEntry)entry).multiplayerLoaded) {
                        newValues.put(entry.id, jsonElement, entry.description);
                    }
                    if (entry.multiplayerSynced) {
                        serverExported.put(entry.id, jsonElement, entry.description);
                    }
                    entry.parentField.setAccessible(true);
                    ((ConfigEntry)entry).saveToField();
                    readValues.getAndIncrement();
                    continue;
                }
                throw new RuntimeException("What?! Config contains a non-serializable entry!");
            }
            if (EventStorage.PRE_SAVE_LISTENERS.containsKey(container.getProvider().getMetadata().getId())) {
                ((PreConfigSavedListener)EventStorage.PRE_SAVE_LISTENERS.get(container.getProvider().getMetadata().getId()).getEntrypoint()).onPreConfigSaved(configFile.exists() ? Jankson.builder().build().load(configFile) : new JsonObject(), newValues);
            }
            if (!configFile.exists()) {
                configFile.getParentFile().mkdirs();
                configFile.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(configFile);
            fileOutputStream.write(newValues.toJson(true, true).getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
            GCCore.log("Successfully saved " + readCategories + " categories, containing " + readValues.get() + " values for " + container.getProvider().getMetadata().getName() + "(" + container.getProvider().getMetadata().getId() + ").");
            return serverExported.toJson();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static BiTuple<JsonObject, JsonObject> saveDeeper(ConfigCategory category, Field childField, AtomicInteger readValues, AtomicInteger readCategories) throws IllegalAccessException {
        JsonObject newValues = new JsonObject();
        JsonObject serverExported = new JsonObject();
        for (ConfigBase entry : category.values.values()) {
            childField.setAccessible(true);
            if (entry instanceof ConfigCategory) {
                BiTuple<JsonObject, JsonObject> values = GCCore.saveDeeper((ConfigCategory)entry, entry.parentField, readValues, readCategories);
                newValues.put(entry.id, (JsonElement)values.one());
                serverExported.put(entry.id, (JsonElement)values.two());
                readCategories.getAndIncrement();
                continue;
            }
            if (entry instanceof ConfigEntry) {
                Function configFactory = (Function)ConfigFactories.saveFactories.get(((ConfigEntry)entry).value.getClass());
                if (configFactory == null) {
                    throw new RuntimeException("Config value \"" + entry.parentObject.getClass().getName() + ";" + entry.id + "\" has no config saver for it's type!");
                }
                JsonElement jsonElement = (JsonElement)configFactory.apply(((ConfigEntry)entry).value);
                if (!((ConfigEntry)entry).multiplayerLoaded) {
                    newValues.put(entry.id, jsonElement, entry.description);
                }
                if (entry.multiplayerSynced) {
                    serverExported.put(entry.id, jsonElement, entry.description);
                }
                ((ConfigEntry)entry).saveToField();
                readValues.getAndIncrement();
                continue;
            }
            throw new RuntimeException("What?! Config contains a non-serializable entry!");
        }
        return BiTuple.of((Object)newValues, (Object)serverExported);
    }

    static {
        Configurator.setLevel((String)"GCAPI", (Level)Level.INFO);
    }
}

