/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.api.gcapi.screen.widget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.glasslauncher.mods.api.gcapi.impl.config.ConfigEntry;
import net.glasslauncher.mods.api.gcapi.screen.widget.IconWidget;

public class ResetConfigWidget
extends IconWidget {
    private final ConfigEntry<?> configEntry;

    public ResetConfigWidget(int x, int y, int width, int height, ConfigEntry<?> configEntry) {
        super(x, y, width, height, "/assets/gcapi/reset.png");
        this.configEntry = configEntry;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button) {
        if (mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height) {
            try {
                if (!this.configEntry.multiplayerLoaded) {
                    this.configEntry.reset(this.configEntry.defaultValue);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setXYWH(int x, int y, int width, int height) {
        super.setXYWH(x, y, width, height);
        this.y -= 10;
    }

    @Override
    public List<String> getTooltip() {
        if (this.configEntry.multiplayerLoaded) {
            return new ArrayList<String>();
        }
        return Collections.singletonList("Reset this config to default.");
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (!this.configEntry.multiplayerLoaded) {
            super.draw(mouseX, mouseY);
        }
    }
}

