/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.api.gcapi.impl.config;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.glasslauncher.mods.api.gcapi.api.DefaultOnNoGCAPIServer;
import net.glasslauncher.mods.api.gcapi.api.DefaultOnVanillaServer;
import net.glasslauncher.mods.api.gcapi.api.HasDrawable;
import net.glasslauncher.mods.api.gcapi.api.MaxLength;
import net.glasslauncher.mods.api.gcapi.api.TriBoolean;
import net.glasslauncher.mods.api.gcapi.api.ValueOnNoGCAPIServer;
import net.glasslauncher.mods.api.gcapi.api.ValueOnVanillaServer;
import net.glasslauncher.mods.api.gcapi.impl.config.ConfigBase;
import net.glasslauncher.mods.api.gcapi.screen.widget.IconWidget;
import net.glasslauncher.mods.api.gcapi.screen.widget.ResetConfigWidget;
import net.minecraft.class_32;
import net.minecraft.class_34;

public abstract class ConfigEntry<T>
extends ConfigBase {
    public T value;
    public final T defaultValue;
    @Environment(value=EnvType.CLIENT)
    protected class_32 parent;
    public boolean multiplayerLoaded = false;
    protected MaxLength maxLength;
    protected List<HasDrawable> drawableList = new ArrayList<HasDrawable>(){};

    public ConfigEntry(String id, String name, String description, Field parentField, Object parentObject, boolean multiplayerSynced, T value, T defaultValue, MaxLength maxLength) {
        super(id, name, description, parentField, parentObject, multiplayerSynced);
        this.maxLength = maxLength;
        this.value = value;
        this.defaultValue = defaultValue;
    }

    @Environment(value=EnvType.CLIENT)
    public void init(class_32 parent, class_34 textRenderer) {
        this.drawableList = new ArrayList<HasDrawable>();
        if (this.multiplayerSynced) {
            this.drawableList.add(new IconWidget(10, -5, 0, 0, "/assets/gcapi/server_synced.png"));
        }
        this.drawableList.add(new ResetConfigWidget(10, -5, 0, 0, this));
    }

    public abstract T getDrawableValue();

    public abstract void setDrawableValue(T var1);

    public abstract boolean isValueValid();

    public void saveToField() throws IllegalAccessException {
        this.parentField.set(this.parentObject, this.value);
    }

    public MaxLength getMaxLength() {
        return this.maxLength;
    }

    public abstract void reset(Object var1) throws IllegalAccessException;

    @Deprecated(since="2.1.0", forRemoval=true)
    public void vanillaServerBehavior() {
        try {
            if (this.parentField.getAnnotation(DefaultOnVanillaServer.class) != null) {
                this.multiplayerLoaded = true;
                this.reset(this.defaultValue);
            } else if (this.parentField.getAnnotation(ValueOnVanillaServer.class) != null) {
                ValueOnVanillaServer valueOnVanillaServer = this.parentField.getAnnotation(ValueOnVanillaServer.class);
                this.multiplayerLoaded = true;
                if (!valueOnVanillaServer.stringValue().equals("")) {
                    this.reset(valueOnVanillaServer.stringValue());
                } else if (valueOnVanillaServer.booleanValue() != TriBoolean.DEFAULT) {
                    this.reset(valueOnVanillaServer.booleanValue().value);
                } else if (valueOnVanillaServer.integerValue() != 0) {
                    this.reset(valueOnVanillaServer.integerValue());
                } else if (valueOnVanillaServer.floatValue() != 0.0f) {
                    this.reset(Float.valueOf(valueOnVanillaServer.floatValue()));
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void noGCAPIBehaviour(boolean vanilla) {
        try {
            if (!vanilla && this.parentField.getAnnotation(DefaultOnNoGCAPIServer.class) != null) {
                this.multiplayerLoaded = true;
                this.reset(this.defaultValue);
            } else if (!vanilla && this.parentField.getAnnotation(ValueOnNoGCAPIServer.class) != null) {
                ValueOnNoGCAPIServer valueOnNoGCAPIServer = this.parentField.getAnnotation(ValueOnNoGCAPIServer.class);
                this.multiplayerLoaded = true;
                if (!valueOnNoGCAPIServer.stringValue().equals("")) {
                    this.reset(valueOnNoGCAPIServer.stringValue());
                } else if (valueOnNoGCAPIServer.booleanValue() != TriBoolean.DEFAULT) {
                    this.reset(valueOnNoGCAPIServer.booleanValue().value);
                } else if (valueOnNoGCAPIServer.integerValue() != 0) {
                    this.reset(valueOnNoGCAPIServer.integerValue());
                } else if (valueOnNoGCAPIServer.floatValue() != 0.0f) {
                    this.reset(Float.valueOf(valueOnNoGCAPIServer.floatValue()));
                }
            } else {
                this.vanillaServerBehavior();
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

