/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.api.gcapi.impl.config.entry;

import com.google.common.collect.Iterables;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.glasslauncher.mods.api.gcapi.api.CharacterUtils;
import net.glasslauncher.mods.api.gcapi.api.ConfigEntryWithButton;
import net.glasslauncher.mods.api.gcapi.api.HasDrawable;
import net.glasslauncher.mods.api.gcapi.impl.config.ConfigEntry;
import net.glasslauncher.mods.api.gcapi.screen.widget.FancyButtonWidget;
import net.minecraft.class_32;
import net.minecraft.class_34;
import org.jetbrains.annotations.NotNull;

public class EnumConfigEntry<T extends Enum<?>>
extends ConfigEntry<Integer>
implements ConfigEntryWithButton {
    private FancyButtonWidget button;
    public final Enum<?>[] parentEnumArray;

    public EnumConfigEntry(String id, String name, String description, Field parentField, Object parentObject, boolean multiplayerSynced, Integer value, Integer defaultValue, Class parentEnum) {
        super(id, name, description, parentField, parentObject, multiplayerSynced, value, defaultValue, null);
        this.parentEnumArray = (Enum[])Iterables.toArray(EnumSet.allOf(parentEnum), (Class)parentEnum);
    }

    @Override
    public void init(class_32 parent, class_34 textRenderer) {
        super.init(parent, textRenderer);
        this.button = new FancyButtonWidget(10, 0, 0, 0, 0, this.getButtonText(), CharacterUtils.getIntFromColour(new Color(255, 202, 0, 255)));
        this.drawableList.add(this.button);
        this.button.field_1374 = !this.multiplayerLoaded;
    }

    @Override
    public Integer getDrawableValue() {
        return (Integer)this.value;
    }

    @Override
    public void setDrawableValue(Integer value) {
        this.value = value;
        if (this.button != null) {
            this.button.field_1372 = this.getButtonText();
        }
    }

    @Override
    public boolean isValueValid() {
        return true;
    }

    @Override
    @NotNull
    public List<HasDrawable> getDrawables() {
        return this.drawableList;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onClick() {
        Integer n = (Integer)this.value;
        this.value = (Integer)this.value + 1;
        if ((Integer)this.value > this.parentEnumArray.length - 1) {
            this.value = 0;
        }
        this.button.field_1372 = this.getButtonText();
    }

    @Override
    public void reset(Object defaultValue) throws IllegalAccessException {
        this.value = (Integer)defaultValue;
        this.setDrawableValue((Integer)defaultValue);
        this.saveToField();
    }

    @Override
    public void saveToField() throws IllegalAccessException {
        this.parentField.set(this.parentObject, this.parentEnumArray[(Integer)this.value]);
    }

    public String getButtonText() {
        return this.parentEnumArray[(Integer)this.value].toString() + " (" + ((Integer)this.value + 1) + "/" + this.parentEnumArray.length + ")";
    }
}

