package net.glasslauncher.mods.gcapi.mixin.client;

import net.glasslauncher.mods.gcapi.api.CharacterUtils;
import net.glasslauncher.mods.gcapi.api.HasToolTip;
import net.glasslauncher.mods.gcapi.impl.screen.ScreenAccessor;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_34;
import net.minecraft.class_584;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.*;
import java.util.concurrent.atomic.*;
import java.util.stream.*;

@Mixin(class_32.class)
public class ScreenMixin extends class_584 implements ScreenAccessor {

    @Shadow protected class_34 textRenderer;

    @SuppressWarnings("rawtypes")
    @Shadow protected List buttons;

    @Shadow private class_33 selectedButton;

    @Inject(method = "render", at = @At(value = "TAIL"))
    public void drawTooltipStuff(int mouseX, int mouseY, float delta, CallbackInfo ci) {
        List<String> tooltip = glass_config_api$getMouseTooltip(mouseX, mouseY, new ArrayList<>());
        if (tooltip != null) {
            CharacterUtils.renderTooltip(textRenderer, tooltip, mouseX, mouseY, (class_32) (Object) this);
        }
    }

    @Override
    public List<String> glass_config_api$getMouseTooltip(int mouseX, int mouseY, List<?> extraObjectsToCheck) {
        AtomicReference<List<String>> tooltip = new AtomicReference<>(null);
        //noinspection unchecked
        Stream.of(buttons, extraObjectsToCheck).flatMap(Collection::stream).forEach((widget) -> {
            if (widget instanceof HasToolTip && isMouseInBounds(((HasToolTip) widget).getXYWH(), mouseX, mouseY)) {
                tooltip.set(((HasToolTip) widget).getTooltip());
            }
        });
        return tooltip.get();
    }

    @Override
    public void glass_config_api$setSelectedButton(class_33 value) {
        selectedButton = value;
    }

    @Unique
    public boolean isMouseInBounds(int[] xywh, int mouseX, int mouseY) {
        return mouseX >= xywh[0] && mouseX <= xywh[0] + xywh[2] && mouseY >= xywh[1] && mouseY <= xywh[1] + xywh[3];
    }

}
