/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.gcapi.api;

import com.google.common.base.CharMatcher;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import net.glasslauncher.mods.gcapi.impl.DrawContextAccessor;
import net.minecraft.class_32;
import net.minecraft.class_34;
import net.minecraft.class_89;
import org.lwjgl.opengl.GL11;

public class CharacterUtils {
    public static void renderTooltip(class_34 textRenderer, List<String> tooltip, int x, int y, class_32 screen) {
        if (!tooltip.isEmpty()) {
            GL11.glDisable((int)32826);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String string : tooltip) {
                int l = textRenderer.method_1901(string);
                if (l <= k) continue;
                k = l;
            }
            int m = x + 12;
            int n = y - 12;
            int p = 8;
            if (tooltip.size() > 1) {
                p += 2 + (tooltip.size() - 1) * 10;
            }
            if (m + k > screen.field_152) {
                m -= 28 + k;
            }
            if (n + p + 6 > screen.field_153) {
                n = screen.field_153 - p - 6;
            }
            int transparentGrey = -1073741824;
            int margin = 3;
            ((DrawContextAccessor)screen).glass_config_api$invokeFill(m - margin, n - margin, m + k + margin, n + p + margin, transparentGrey);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
            for (int t = 0; t < tooltip.size(); ++t) {
                String string2 = tooltip.get(t);
                if (string2 != null) {
                    textRenderer.method_1906(string2, m, n, 0xFFFFFF);
                }
                if (t == 0) {
                    n += 2;
                }
                n += 10;
            }
            GL11.glPopMatrix();
            GL11.glEnable((int)2929);
            GL11.glEnable((int)32826);
        }
    }

    public static int getIntFromColour(Color colour) {
        return (colour.getAlpha() & 0xFF) << 24 | (colour.getRed() & 0xFF) << 16 | (colour.getGreen() & 0xFF) << 8 | colour.getBlue() & 0xFF;
    }

    public static boolean isInteger(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        int i = 0;
        if (str.charAt(0) == '-') {
            if (length == 1) {
                return false;
            }
            i = 1;
        }
        while (i < length) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isFloat(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0 || str.charAt(0) == '.' || str.charAt(str.length() - 1) == '.' || CharMatcher.is((char)'.').countIn((CharSequence)str) > 1) {
            return false;
        }
        int i = 0;
        if (str.charAt(0) == '-') {
            if (length == 1) {
                return false;
            }
            i = 1;
        }
        while (i < length) {
            char c = str.charAt(i);
            if ((c < '0' || c > '9') && c != '.') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isCharacterValid(char c) {
        return c != '\u00a7' && (class_89.field_298.indexOf(c) >= 0 || c > ' ');
    }

    public static String stripInvalidChars(String string) {
        char[] var2;
        StringBuilder var1 = new StringBuilder();
        for (char var5 : var2 = string.toCharArray()) {
            if (!CharacterUtils.isCharacterValid(var5)) continue;
            var1.append(var5);
        }
        return var1.toString();
    }

    public static void setClipboardText(String string) {
        try {
            StringSelection var1 = new StringSelection(string);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(var1, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getClipboardText() {
        try {
            Transferable var0 = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (var0 != null && var0.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)var0.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getRenderableString(String string, int maxPixelWidth, boolean flag, class_34 textRenderer) {
        StringBuilder var4 = new StringBuilder();
        int currentPixelWidth = 0;
        int var6 = flag ? string.length() - 1 : 0;
        int var7 = flag ? -1 : 1;
        boolean var8 = false;
        boolean var9 = false;
        for (int var10 = var6; var10 >= 0 && var10 < string.length() && currentPixelWidth < maxPixelWidth; var10 += var7) {
            char var11 = string.charAt(var10);
            int var12 = textRenderer.method_1901(Character.toString(var11));
            if (var8) {
                var8 = false;
                if (var11 != 'l' && var11 != 'L') {
                    if (var11 == 'r' || var11 == 'R') {
                        var9 = false;
                    }
                } else {
                    var9 = true;
                }
            } else if (var12 < 0) {
                var8 = true;
            } else {
                currentPixelWidth += var12;
                if (var9) {
                    ++currentPixelWidth;
                }
            }
            if (currentPixelWidth > maxPixelWidth) break;
            if (flag) {
                var4.insert(0, var11);
                continue;
            }
            var4.append(var11);
        }
        return var4.toString();
    }
}

