/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.gcapi.impl.object.entry;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import net.glasslauncher.mods.gcapi.api.ConfigEntry;
import net.glasslauncher.mods.gcapi.api.HasDrawable;
import net.glasslauncher.mods.gcapi.impl.object.ConfigEntryHandler;
import net.glasslauncher.mods.gcapi.impl.screen.widget.ExtensibleTextFieldWidget;
import net.minecraft.class_32;
import net.minecraft.class_34;
import org.jetbrains.annotations.NotNull;

public class StringConfigEntryHandler
extends ConfigEntryHandler<String> {
    private ExtensibleTextFieldWidget textbox;

    public StringConfigEntryHandler(String id, ConfigEntry configEntry, Field parentField, Object parentObject, boolean multiplayerSynced, String value, String defaultValue) {
        super(id, configEntry, parentField, parentObject, multiplayerSynced, value, defaultValue);
        this.textValidator = str -> StringConfigEntryHandler.stringValidator(configEntry, str);
    }

    @Override
    public void init(class_32 parent, class_34 textRenderer) {
        super.init(parent, textRenderer);
        this.textbox = new ExtensibleTextFieldWidget(textRenderer);
        this.textbox.setValidator(this.textValidator);
        this.textbox.setMaxLength(Math.toIntExact(this.configEntry.maxLength()));
        this.textbox.setText((String)this.value);
        this.textbox.setEnabled(!this.multiplayerLoaded);
        this.drawableList.add(this.textbox);
    }

    @Override
    public String getDrawableValue() {
        return this.textbox == null ? null : this.textbox.getText();
    }

    @Override
    public void setDrawableValue(String value) {
        this.textbox.setText(value);
    }

    @Override
    public boolean isValueValid() {
        return true;
    }

    @Override
    @NotNull
    public List<HasDrawable> getDrawables() {
        return this.drawableList;
    }

    @Override
    public void reset(Object defaultValue) throws IllegalAccessException {
        this.value = (String)defaultValue;
        this.setDrawableValue((String)defaultValue);
        this.saveToField();
    }

    public static List<String> stringValidator(ConfigEntry configEntry, String str) {
        if ((long)str.length() > configEntry.maxLength()) {
            return Collections.singletonList("Value is too long");
        }
        if ((long)str.length() < configEntry.minLength()) {
            return Collections.singletonList("Value is too short");
        }
        return null;
    }
}

