package net.glasslauncher.mods.gcapi.impl.screen;

import net.glasslauncher.mods.gcapi.api.CharacterUtils;
import net.glasslauncher.mods.gcapi.api.ConfigEntry;
import net.glasslauncher.mods.gcapi.impl.object.ConfigEntryHandler;
import net.glasslauncher.mods.gcapi.impl.screen.widget.ExtensibleTextFieldWidget;
import net.glasslauncher.mods.gcapi.impl.screen.widget.TexturedButtonWidget;
import net.glasslauncher.mods.gcapi.mixin.client.EntryListWidgetAccessor;
import net.minecraft.class_300;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_35;
import net.minecraft.class_97;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;

import java.awt.*;
import java.util.*;
import java.util.concurrent.atomic.*;
import java.util.function.*;

public abstract class BaseListScreenBuilder<T> extends class_32 {

    protected ScreenScrollList scrollList;
    protected final class_32 parent;
    protected int mouseX = -1;
    protected int mouseY = -1;
    protected ConfigEntryHandler<T[]> configEntry;
    public final List<ExtensibleTextFieldWidget> textFieldWidgets = new ArrayList<>();
    protected Function<String, List<String>> validator;
    protected final ConfigEntry configAnnotation;
    private boolean isInUse = false;

    protected BaseListScreenBuilder(class_32 parent, ConfigEntry configAnnotation, ConfigEntryHandler<T[]> configEntry, Function<String, List<String>> validator) {
        this.parent = parent;
        this.configAnnotation = configAnnotation;
        this.configEntry = configEntry;
        this.validator = validator;
    }

    public void setValues(List<T> list) {
        textFieldWidgets.clear();
        list.forEach((value) -> {
            ExtensibleTextFieldWidget textbox = new ExtensibleTextFieldWidget(field_156);
            textbox.setValidator(validator);
            textbox.setMaxLength(Math.toIntExact(configAnnotation.maxLength())); // This helper throws an exception if the number is too high for an int. Handy!
            textbox.setText(String.valueOf(value));
            textFieldWidgets.add(textbox);
        });
    }

    public void setValues(T[] list) {
        setValues(Arrays.asList(list));
    }

    @Override
    public void method_125(Minecraft minecraft, int width, int height) {
        this.field_157 = new class_35(minecraft);
        this.field_151 = minecraft;
        this.field_156 = minecraft.field_2815;
        this.field_152 = width;
        this.field_153 = height;
        method_119();
    }

    @Override
    public void method_119() {
        if (isInUse) {
            scrollList = new ScreenScrollList();
            class_33 button = ((class_33)field_154.get(0));
            button.field_1370 = field_152/2-75;
            button.field_1371 = field_153-26;
            button = ((class_33)field_154.get(1));
            button.field_1370 = ((field_152/3)*2)-75;
            button.field_1371 = field_153-48;
            return;
        }
        setValues(configEntry.value);
        field_154.clear();
        this.scrollList = new ScreenScrollList();
        //noinspection unchecked
        field_154.add(new class_33(0,field_152/2-75, field_153-26, 150, 20, class_300.method_992().method_993("gui.cancel")));
        //noinspection unchecked
        field_154.add(new TexturedButtonWidget(1,((field_152/3)*2)-75, field_153-48, 20, 20, 0, 0, "assets/gcapi/add_button.png", 32, 64, "Add a new entry at the end"));
        AtomicInteger id = new AtomicInteger(1);
        textFieldWidgets.forEach((te) -> {
            //noinspection unchecked
            field_154.add(new TexturedButtonWidget(id.incrementAndGet(),0, 0, 20, 20, 0, 0, "assets/gcapi/remove_button.png", 32, 64, "Remove the entry on this line"));
        });
        isInUse = true;
    }

    @Override
    public void method_122() {
        super.method_122();
        for (ExtensibleTextFieldWidget configBase : textFieldWidgets) {
            configBase.tick();
        }
    }

    @Override
    protected void method_117(char character, int key) {
        super.method_117(character, key);
        for (ExtensibleTextFieldWidget configBase : textFieldWidgets) {
            configBase.keyPressed(character, key);
        }
    }

    @Override
    public void method_118(int mouseX, int mouseY, float delta) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        scrollList.method_1256(mouseX, mouseY, delta);
        // Breaks rendering of category buttons.
        //super.render(mouseX, mouseY, delta);
        ((class_33) field_154.get(0)).method_1186(field_151, mouseX, mouseY);
        ((class_33) field_154.get(1)).method_1186(field_151, mouseX, mouseY);
        field_156.method_1903(configEntry.name, (field_152 / 2) - (field_156.method_1901(configEntry.name) / 2), 4, 16777215);
        field_156.method_1903(configEntry.description, (field_152 / 2) - (field_156.method_1901(configEntry.description) / 2), 18, 8421504);

        ConfigEntry maxLength = configEntry.parentField.getAnnotation(ConfigEntry.class);
        if (textFieldWidgets.size() < maxLength.minArrayLength() || textFieldWidgets.size() > maxLength.maxArrayLength()) {
            String text = "Array is not the right size! (" + textFieldWidgets.size() + " outside of " + maxLength.minArrayLength() + " / " + maxLength.maxArrayLength() + ")";
            field_156.method_1903(text, (field_152 / 2) - (field_156.method_1901(text) / 2), 34, CharacterUtils.getIntFromColour(Color.RED));
        }

        List<String> tooltip = ((ScreenAccessor) this).glass_config_api$getMouseTooltip(mouseX, mouseY, textFieldWidgets);
        if (tooltip != null) {
            CharacterUtils.renderTooltip(field_156, tooltip, mouseX, mouseY, this);
        }
    }

    @Override
    public void method_131() {
        super.method_131();
        float dWheel = Mouse.getDWheel();
        if (Mouse.isButtonDown(0)) {
            for (ExtensibleTextFieldWidget configBase : textFieldWidgets) {
                    configBase.mouseClicked(mouseX, mouseY, 0);
            }
        }
        else if (dWheel != 0) {
            scrollList.scroll(-(dWheel/10));
        }
    }

    @Override
    protected void method_120(class_33 button) {
        if (button.field_1373 == 0) {
            isInUse = false;
            field_151.method_2112(parent);
        }
        else if (button.field_1373 == 1) {
            ExtensibleTextFieldWidget textbox = new ExtensibleTextFieldWidget(field_156);
            textbox.setValidator(validator);
            textbox.setText("");
            textFieldWidgets.add(textbox);
            //noinspection unchecked
            field_154.add(new TexturedButtonWidget(field_154.size(),0, 0, 20, 20, 0, 0, "assets/gcapi/remove_button.png", 32, 64, "Remove the entry on this line"));
        }
        else if (button.field_1373 > 1) {
            textFieldWidgets.remove(button.field_1373-2);
            field_154.remove(button.field_1373);
            for (int i = 1; i<field_154.size(); i++) {
                ((class_33) field_154.get(i)).field_1373 = i;
            }
        }
    }

    abstract T convertStringToValue(String value);

    @Override
    public void method_133() {
        if (isInUse) {
            return;
        }
        List<T> list = new ArrayList<>();
        textFieldWidgets.forEach((value) -> {
            if (value.isValueValid()) {
                list.add(convertStringToValue(value.getText()));
            }
        });
        //noinspection unchecked
        configEntry.value = (T[]) list.toArray();
        super.method_133();
    }

    class ScreenScrollList extends class_97 {
        public ScreenScrollList() {
            super(BaseListScreenBuilder.this.field_151, BaseListScreenBuilder.this.field_152, BaseListScreenBuilder.this.field_153, 32, BaseListScreenBuilder.this.field_153 - 64, 24);

        }

        public void scroll(float value) {
            EntryListWidgetAccessor baseAccessor = ((EntryListWidgetAccessor) this);
            baseAccessor.setScrollAmount(baseAccessor.getScrollAmount() + value);
        }

        @Override
        protected int method_1266() {
            return textFieldWidgets.size();
        }

        @Override
        protected void method_1267(int entryIndex, boolean doLoad) {
        }

        @Override
        protected boolean method_1270(int i) {
            return false;
        }

        @Override
        protected void method_1269() {
            BaseListScreenBuilder.this.method_134();
        }

        @Override
        protected void method_1264(int itemId, int x, int y, int i1, net.minecraft.class_67 arg) {
            if (itemId+2 >= field_154.size()) {
                return;
            }
            ExtensibleTextFieldWidget configBase = textFieldWidgets.get(itemId);
            BaseListScreenBuilder.this.method_1937(field_156, String.valueOf(itemId), x - 2 - field_156.method_1901(String.valueOf(itemId)), y + 1, 16777215);
            ((TexturedButtonWidget) field_154.get(itemId+2)).setPos(x + 214 + 34, y+2);
            ((TexturedButtonWidget) field_154.get(itemId+2)).method_1186(field_151, mouseX, mouseY);
            configBase.glass_config_api$setXYWH(x + 2, y + 1, 212, 20);
            configBase.draw(mouseX, mouseY);
        }
    }
}
