/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.gcapi.impl.object;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.glasslauncher.mods.gcapi.api.ConfigEntry;
import net.glasslauncher.mods.gcapi.api.DefaultOnVanillaServer;
import net.glasslauncher.mods.gcapi.api.HasDrawable;
import net.glasslauncher.mods.gcapi.api.TriBoolean;
import net.glasslauncher.mods.gcapi.api.ValueOnVanillaServer;
import net.glasslauncher.mods.gcapi.impl.object.ConfigHandlerBase;
import net.glasslauncher.mods.gcapi.impl.screen.widget.IconWidget;
import net.glasslauncher.mods.gcapi.impl.screen.widget.ResetConfigWidget;
import net.minecraft.class_32;
import net.minecraft.class_34;

public abstract class ConfigEntryHandler<T>
extends ConfigHandlerBase {
    public T value;
    public final T defaultValue;
    public boolean multiplayerLoaded = false;
    protected ConfigEntry configEntry;
    protected List<HasDrawable> drawableList = new ArrayList<HasDrawable>(){};
    protected Function<String, List<String>> textValidator;

    public ConfigEntryHandler(String id, ConfigEntry configEntry, Field parentField, Object parentObject, boolean multiplayerSynced, T value, T defaultValue) {
        super(id, configEntry.name(), configEntry.description(), parentField, parentObject, multiplayerSynced);
        this.configEntry = configEntry;
        this.value = value;
        this.defaultValue = defaultValue;
    }

    @Environment(value=EnvType.CLIENT)
    public void init(class_32 parent, class_34 textRenderer) {
        this.drawableList = new ArrayList<HasDrawable>();
        if (this.multiplayerSynced) {
            this.drawableList.add(new IconWidget(10, -5, 0, 0, "/assets/gcapi/server_synced.png"));
        }
        this.drawableList.add(new ResetConfigWidget(10, -5, 0, 0, this));
    }

    public abstract T getDrawableValue();

    public abstract void setDrawableValue(T var1);

    public abstract boolean isValueValid();

    public void saveToField() throws IllegalAccessException {
        this.parentField.set(this.parentObject, this.value);
    }

    public abstract void reset(Object var1) throws IllegalAccessException;

    public void vanillaServerBehavior() {
        try {
            if (this.parentField.getAnnotation(DefaultOnVanillaServer.class) != null) {
                this.multiplayerLoaded = true;
                this.reset(this.defaultValue);
            } else if (this.parentField.getAnnotation(ValueOnVanillaServer.class) != null) {
                ValueOnVanillaServer valueOnVanillaServer = this.parentField.getAnnotation(ValueOnVanillaServer.class);
                this.multiplayerLoaded = true;
                if (!valueOnVanillaServer.stringValue().isEmpty()) {
                    this.reset(valueOnVanillaServer.stringValue());
                } else if (valueOnVanillaServer.booleanValue() != TriBoolean.DEFAULT) {
                    this.reset(valueOnVanillaServer.booleanValue().value);
                } else if (valueOnVanillaServer.integerValue() != 0) {
                    this.reset(valueOnVanillaServer.integerValue());
                } else if (valueOnVanillaServer.floatValue() != 0.0f) {
                    this.reset(Float.valueOf(valueOnVanillaServer.floatValue()));
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

