package net.glasslauncher.mods.gcapi3.impl.screen;

import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.glasslauncher.mods.gcapi3.api.CharacterUtils;
import net.glasslauncher.mods.gcapi3.api.ConfigCategory;
import net.glasslauncher.mods.gcapi3.api.ConfigEntry;
import net.glasslauncher.mods.gcapi3.api.ConfigEntryWithButton;
import net.glasslauncher.mods.gcapi3.api.HasDrawable;
import net.glasslauncher.mods.gcapi3.impl.object.ConfigCategoryHandler;
import net.glasslauncher.mods.gcapi3.impl.object.ConfigEntryHandler;
import net.glasslauncher.mods.gcapi3.impl.object.ConfigHandlerBase;
import net.glasslauncher.mods.gcapi3.mixin.client.EntryListWidgetAccessor;
import net.minecraft.class_300;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_67;
import net.minecraft.class_97;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;

import java.util.*;

public class ScreenBuilder extends class_32 {

    protected ScreenScrollList scrollList;
    protected HashMap<Integer, ConfigHandlerBase> buttonToEntry;
    protected final ConfigCategoryHandler baseCategory;
    protected int selectedIndex = -1;
    protected final class_32 parent;
    protected final ModContainer mod;
    protected int mouseX = -1;
    protected int mouseY = -1;
    protected List<ConfigHandlerBase> configHandlerBases = new ArrayList<>();
    protected int backButtonID;
    protected List<class_33> screenButtons = new ArrayList<>();

    public ScreenBuilder(class_32 parent, ModContainer mod, ConfigCategoryHandler baseCategory) {
        this.parent = parent;
        this.mod = mod;
        this.baseCategory = baseCategory;
        configHandlerBases.addAll(baseCategory.values.values());
        configHandlerBases.sort((self, other) -> {
            if (other instanceof ConfigCategoryHandler) {
                return 1;
            }
            return self instanceof ConfigCategoryHandler ? -1 : self.name.compareTo(other.name);
        });
    }

    @Override
    public void method_119() {
        baseCategory.values.values().forEach((value) -> {
            if (value instanceof ConfigCategoryHandler) {
                if (value.parentField.getAnnotation(ConfigCategory.class).hidden()) {
                    return;
                }
            }
            //noinspection rawtypes
            if (value instanceof ConfigEntryHandler configEntry) {
                if (configEntry.parentField.getAnnotation(ConfigEntry.class).hidden()) {
                    return;
                }
                if (configEntry.parentField.getAnnotation(ConfigEntry.class).hidden()) {
                    return;
                }
                if (configEntry.getDrawableValue() != null) {
                    configEntry.value = configEntry.getDrawableValue();
                }
            }
        });
        field_154.clear();
        screenButtons.clear();
        this.scrollList = new ScreenScrollList();
        this.buttonToEntry = new HashMap<>();
        class_33 button = new class_33(backButtonID = field_154.size(),field_152/2-75, field_153-26, 150, 20, class_300.method_992().method_993("gui.done"));
        //noinspection unchecked
        field_154.add(button);
        screenButtons.add(button);
        baseCategory.values.values().forEach((value) -> {
            if (value instanceof ConfigCategoryHandler) {
                if (value.parentField.getAnnotation(ConfigCategory.class).hidden()) {
                    return;
                }
            }
            if (value instanceof ConfigEntryHandler) {
                if (value.parentField.getAnnotation(ConfigEntry.class).hidden()) {
                    return;
                }
                ((ConfigEntryHandler<?>) value).init(this, field_156);
            }
            value.getDrawables().forEach(val -> {
                if (val instanceof class_33) {
                    val.setID(field_154.size());
                    buttonToEntry.put(field_154.size(), value);
                    //noinspection unchecked
                    field_154.add(val);
                }
            });
        });
    }

    @Override
    public void method_122() {
        super.method_122();
        for (ConfigHandlerBase value : baseCategory.values.values()) {
            if (value instanceof ConfigCategoryHandler) {
                if (value.parentField.getAnnotation(ConfigCategory.class).hidden()) {
                    return;
                }
            }
            if (value instanceof ConfigEntryHandler) {
                if (value.parentField.getAnnotation(ConfigEntry.class).hidden()) {
                    return;
                }
                value.getDrawables().forEach(HasDrawable::tick);
            }
        }
    }

    @Override
    protected void method_117(char character, int key) {
        super.method_117(character, key);
        for (ConfigHandlerBase value : baseCategory.values.values()) {
            if (value instanceof ConfigCategoryHandler) {
                if (value.parentField.getAnnotation(ConfigCategory.class).hidden()) {
                    return;
                }
            }
            if (value instanceof ConfigEntryHandler) {
                if (value.parentField.getAnnotation(ConfigEntry.class).hidden()) {
                    return;
                }
                value.getDrawables().forEach(val -> val.keyPressed(character, key));
            }
        }
    }

    @SuppressWarnings("CommentedOutCode") // I want to show code differences.
    @Override
    public void method_118(int mouseX, int mouseY, float delta) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        scrollList.method_1256(mouseX, mouseY, delta);
        // Breaks rendering of category buttons.
        //super.render(mouseX, mouseY, delta);
        //((ButtonWidget) buttons.get(backButtonID)).render(minecraft, mouseX, mouseY);
        screenButtons.forEach(button -> button.method_1186(field_151, mouseX, mouseY));
        field_156.method_1903(baseCategory.name, (field_152/2) - (field_156.method_1901(baseCategory.name)/2), 4, 16777215);
        field_156.method_1903(baseCategory.description, (field_152/2) - (field_156.method_1901(baseCategory.description)/2), 18, 8421504);
        ArrayList<HasDrawable> drawables = new ArrayList<>();
        configHandlerBases.forEach((configHandlerBase -> drawables.addAll(configHandlerBase.getDrawables())));
        if(mouseY > 32 && mouseY < field_153 - 33) {
            List<String> tooltip = ((ScreenAccessor) this).glass_config_api$getMouseTooltip(mouseX, mouseY, drawables);
            if (tooltip != null) {
                CharacterUtils.renderTooltip(field_156, tooltip, mouseX, mouseY, this);
            }
        }
    }

    @Override
    protected void method_124(int mouseX, int mouseY, int buttonID) {
        if(mouseY < 32 || mouseY > field_153 - 33) {
            for (class_33 button : screenButtons) {
                if (button.method_1189(field_151, mouseX, mouseY)) {
                    ((ScreenAccessor) this).glass_config_api$setSelectedButton(button);
                    field_151.field_2766.method_2009("random.click", 1.0F, 1.0F);
                    method_120(button);
                }
            }

            return;
        }
        if (buttonID != 0) { // We only want left click
            return;
        }

        for (Object buttonObj : field_154) {
            class_33 button = (class_33) buttonObj;
            if (button.method_1189(field_151, mouseX, mouseY)) {
                ((ScreenAccessor) this).glass_config_api$setSelectedButton(button);
                field_151.field_2766.method_2009("random.click", 1.0F, 1.0F);
                method_120(button);
            }
        }
    }

    @Override
    public void method_131() {
        super.method_131();
        float dWheel = Mouse.getDWheel();
        if (Mouse.isButtonDown(0) && mouseY > 32 && mouseY < field_153 - 33) {
            for (ConfigHandlerBase configHandlerBase : baseCategory.values.values()) {
                if (configHandlerBase instanceof ConfigEntryHandler) {
                    configHandlerBase.getDrawables().forEach(val -> val.mouseClicked(mouseX, mouseY, 0));
                }
            }
        }
        else if (dWheel != 0) {
            scrollList.scroll(-(dWheel/10));
        }
    }

    @Override
    protected void method_120(class_33 button) {
        if (button.field_1373 == backButtonID) {
            saveToEntries();
            field_151.method_2112(parent);
        }
        else if (mouseY >= 32 && mouseY <= field_153 - 33) {
            if (buttonToEntry.get(button.field_1373) instanceof ConfigEntryWithButton) {
                ((ConfigEntryWithButton) buttonToEntry.get(button.field_1373)).onClick();
            }
            else if (buttonToEntry.get(button.field_1373) instanceof ConfigCategoryHandler) {
                //noinspection deprecation
                ((Minecraft) FabricLoader.getInstance().getGameInstance()).method_2112(((ConfigCategoryHandler) buttonToEntry.get(button.field_1373)).getConfigScreen(this, mod));
            }
        }
    }

    public void saveToEntries() {
        baseCategory.values.values().forEach((value) -> {
            if (value instanceof ConfigEntryHandler<?>) {
                //noinspection rawtypes
                ConfigEntryHandler configEntry = (ConfigEntryHandler<?>) value;
                if (configEntry.isValueValid()) {
                    configEntry.value = configEntry.getDrawableValue();
                }
                else {
                    //noinspection unchecked
                    configEntry.setDrawableValue(configEntry.value);
                }
            }
        });
    }

    class ScreenScrollList extends class_97 {
        public ScreenScrollList() {
            super(ScreenBuilder.this.field_151, ScreenBuilder.this.field_152, ScreenBuilder.this.field_153, 32, ScreenBuilder.this.field_153 - 32, 48);
            this.method_1260(false);
        }

        public void scroll(float value) {
            EntryListWidgetAccessor baseAccessor = ((EntryListWidgetAccessor) this);
            baseAccessor.setScrollAmount(baseAccessor.getScrollAmount() + value);
        }

        @Override
        protected int method_1266() {
            return configHandlerBases.size();
        }

        @Override
        protected void method_1267(int entryIndex, boolean doLoad) {
            ScreenBuilder.this.selectedIndex = entryIndex;
        }

        @Override
        protected boolean method_1270(int i) {
            return i == selectedIndex;
        }

        @Override
        protected void method_1269() {
            ScreenBuilder.this.method_134();
        }

        @Override
        protected void method_1264(int itemId, int x, int y, int i1, class_67 arg) {
            ConfigHandlerBase configHandlerBase = configHandlerBases.get(itemId);
            ScreenBuilder.this.method_1937(ScreenBuilder.this.field_156, configHandlerBase.name, x + 2, y + 1, 16777215);
            configHandlerBase.getDrawables().forEach(val -> val.setXYWH(x + 2, y + 12, 212, 20));
            configHandlerBase.getDrawables().forEach(val -> val.draw(mouseX, mouseY));
            ScreenBuilder.this.method_1937(ScreenBuilder.this.field_156, configHandlerBase.description, x + 2, y + 34, 8421504);
        }
    }
}
