/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.gcapi3.impl.factory;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.glasslauncher.mods.gcapi3.api.ConfigEntry;
import net.glasslauncher.mods.gcapi3.api.ConfigFactoryProvider;
import net.glasslauncher.mods.gcapi3.impl.object.ConfigEntryHandler;
import net.glasslauncher.mods.gcapi3.impl.object.entry.BooleanConfigEntryHandler;
import net.glasslauncher.mods.gcapi3.impl.object.entry.FloatConfigEntryHandler;
import net.glasslauncher.mods.gcapi3.impl.object.entry.FloatListConfigEntryHandler;
import net.glasslauncher.mods.gcapi3.impl.object.entry.IntegerConfigEntryHandler;
import net.glasslauncher.mods.gcapi3.impl.object.entry.IntegerListConfigEntryHandler;
import net.glasslauncher.mods.gcapi3.impl.object.entry.StringConfigEntryHandler;
import net.glasslauncher.mods.gcapi3.impl.object.entry.StringListConfigEntryHandler;
import uk.co.benjiweber.expressions.function.SeptFunction;

public class DefaultFactoryProvider
implements ConfigFactoryProvider {
    @Override
    public void provideLoadFactories(ImmutableMap.Builder<Type, SeptFunction<String, ConfigEntry, Field, Object, Boolean, Object, Object, ConfigEntryHandler<?>>> immutableBuilder) {
        immutableBuilder.put(String.class, (id, configEntry, parentField, parentObject, isMultiplayerSynced, value, defaultValue) -> new StringConfigEntryHandler((String)id, (ConfigEntry)configEntry, (Field)parentField, parentObject, (boolean)isMultiplayerSynced, String.valueOf(value), String.valueOf(defaultValue)));
        immutableBuilder.put(Integer.class, (id, configEntry, parentField, parentObject, isMultiplayerSynced, value, defaultValue) -> new IntegerConfigEntryHandler((String)id, (ConfigEntry)configEntry, (Field)parentField, parentObject, (boolean)isMultiplayerSynced, Integer.valueOf(String.valueOf(value)), Integer.valueOf(String.valueOf(defaultValue))));
        immutableBuilder.put(Float.class, (id, configEntry, parentField, parentObject, isMultiplayerSynced, value, defaultValue) -> new FloatConfigEntryHandler((String)id, (ConfigEntry)configEntry, (Field)parentField, parentObject, (boolean)isMultiplayerSynced, Float.valueOf(String.valueOf(value)), Float.valueOf(String.valueOf(defaultValue))));
        immutableBuilder.put(Boolean.class, (id, configEntry, parentField, parentObject, isMultiplayerSynced, value, defaultValue) -> new BooleanConfigEntryHandler((String)id, (ConfigEntry)configEntry, (Field)parentField, parentObject, (boolean)isMultiplayerSynced, (boolean)((Boolean)value), (boolean)((Boolean)defaultValue)));
        immutableBuilder.put(String[].class, (id, configEntry, parentField, parentObject, isMultiplayerSynced, value, defaultValue) -> new StringListConfigEntryHandler((String)id, (ConfigEntry)configEntry, (Field)parentField, parentObject, (boolean)isMultiplayerSynced, DefaultFactoryProvider.listOrArrayToArray(value, String[]::new, val -> val), (String[])defaultValue));
        immutableBuilder.put(Integer[].class, (id, configEntry, parentField, parentObject, isMultiplayerSynced, value, defaultValue) -> new IntegerListConfigEntryHandler((String)id, (ConfigEntry)configEntry, (Field)parentField, parentObject, (boolean)isMultiplayerSynced, DefaultFactoryProvider.listOrArrayToArray(value, Integer[]::new, Integer::parseInt), (Integer[])defaultValue));
        immutableBuilder.put(Float[].class, (id, configEntry, parentField, parentObject, isMultiplayerSynced, value, defaultValue) -> new FloatListConfigEntryHandler((String)id, (ConfigEntry)configEntry, (Field)parentField, parentObject, (boolean)isMultiplayerSynced, DefaultFactoryProvider.listOrArrayToArray(value, Float[]::new, Float::parseFloat), (Float[])defaultValue));
    }

    @Override
    public void provideSaveFactories(ImmutableMap.Builder<Type, Function<Object, Object>> immutableBuilder) {
        immutableBuilder.put(String.class, DefaultFactoryProvider::justPass);
        immutableBuilder.put(Integer.class, DefaultFactoryProvider::justPass);
        immutableBuilder.put(Float.class, DefaultFactoryProvider::justPass);
        immutableBuilder.put(Boolean.class, DefaultFactoryProvider::justPass);
        immutableBuilder.put(String[].class, DefaultFactoryProvider::justPass);
        immutableBuilder.put(Integer[].class, DefaultFactoryProvider::justPass);
        immutableBuilder.put(Float[].class, DefaultFactoryProvider::justPass);
    }

    public static <T> T justPass(T object) {
        return object;
    }

    public static <T> T[] listOrArrayToArray(Object object, IntFunction<T[]> type, Function<String, T> elementFixer) {
        if (object instanceof List) {
            List list = (List)object;
            return list.stream().map(val -> elementFixer.apply(val.toString())).toArray(type);
        }
        return (Object[])object;
    }

    public static int enumOrOrdinalToOrdinal(Object enumOrOrdinal) {
        int enumOrdinal = 0;
        if (enumOrOrdinal instanceof Integer) {
            Integer ordinal = (Integer)enumOrOrdinal;
            enumOrdinal = ordinal;
        } else if (enumOrOrdinal instanceof Enum) {
            Enum enumInst = (Enum)enumOrOrdinal;
            enumOrdinal = enumInst.ordinal();
        }
        return enumOrdinal;
    }
}

