/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.gcapi3.impl.object.entry;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import net.glasslauncher.mods.gcapi3.api.CharacterUtils;
import net.glasslauncher.mods.gcapi3.api.ConfigEntry;
import net.glasslauncher.mods.gcapi3.api.HasDrawable;
import net.glasslauncher.mods.gcapi3.impl.object.ConfigEntryHandler;
import net.glasslauncher.mods.gcapi3.impl.screen.widget.ExtensibleTextFieldWidget;
import net.minecraft.class_32;
import net.minecraft.class_34;
import org.jetbrains.annotations.NotNull;

public class IntegerConfigEntryHandler
extends ConfigEntryHandler<Integer> {
    private ExtensibleTextFieldWidget textbox;

    public IntegerConfigEntryHandler(String id, ConfigEntry configEntry, Field parentField, Object parentObject, boolean multiplayerSynced, Integer value, Integer defaultValue) {
        super(id, configEntry, parentField, parentObject, multiplayerSynced, value, defaultValue);
        this.textValidator = str -> IntegerConfigEntryHandler.integerValidator(configEntry, str);
    }

    @Override
    public void init(class_32 parent, class_34 textRenderer) {
        super.init(parent, textRenderer);
        this.textbox = new ExtensibleTextFieldWidget(textRenderer);
        this.textbox.setValidator(this.textValidator);
        this.textbox.setMaxLength(Math.toIntExact(this.configEntry.maxLength()));
        this.textbox.setText(((Integer)this.value).toString());
        this.textbox.setEnabled(!this.multiplayerLoaded);
        this.drawableList.add(this.textbox);
    }

    @Override
    public Integer getDrawableValue() {
        return this.textbox == null ? null : Integer.valueOf(Integer.parseInt(this.textbox.getText()));
    }

    @Override
    public void setDrawableValue(Integer value) {
        this.textbox.setText(value.toString());
    }

    @Override
    public boolean isValueValid() {
        return this.textValidator.apply(((Integer)this.value).toString()) == null;
    }

    @Override
    @NotNull
    public List<HasDrawable> getDrawables() {
        return this.drawableList;
    }

    @Override
    public void reset(Object defaultValue) throws IllegalAccessException {
        this.value = (Integer)defaultValue;
        this.setDrawableValue((Integer)defaultValue);
        this.saveToField();
    }

    public static List<String> integerValidator(ConfigEntry configEntry, String str) {
        if (!CharacterUtils.isInteger(str)) {
            return Collections.singletonList("Value is not a whole number");
        }
        if ((long)Integer.parseInt(str) > configEntry.maxLength()) {
            return Collections.singletonList("Value is too high");
        }
        if ((long)Integer.parseInt(str) < configEntry.minLength()) {
            return Collections.singletonList("Value is too low");
        }
        return null;
    }
}

