/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.gcapi3.impl.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.glasslauncher.mods.gcapi3.api.CharacterUtils;
import net.glasslauncher.mods.gcapi3.api.ConfigCategory;
import net.glasslauncher.mods.gcapi3.api.ConfigEntry;
import net.glasslauncher.mods.gcapi3.api.ConfigEntryWithButton;
import net.glasslauncher.mods.gcapi3.api.HasDrawable;
import net.glasslauncher.mods.gcapi3.impl.object.ConfigCategoryHandler;
import net.glasslauncher.mods.gcapi3.impl.object.ConfigEntryHandler;
import net.glasslauncher.mods.gcapi3.impl.object.ConfigHandlerBase;
import net.glasslauncher.mods.gcapi3.impl.screen.ScreenAccessor;
import net.glasslauncher.mods.gcapi3.mixin.client.EntryListWidgetAccessor;
import net.minecraft.class_300;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_67;
import net.minecraft.class_97;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;

public class ScreenBuilder
extends class_32 {
    protected ScreenScrollList scrollList;
    protected HashMap<Integer, ConfigHandlerBase> buttonToEntry;
    protected final ConfigCategoryHandler baseCategory;
    protected int selectedIndex = -1;
    protected final class_32 parent;
    protected final ModContainer mod;
    protected int mouseX = -1;
    protected int mouseY = -1;
    protected List<ConfigHandlerBase> configHandlerBases = new ArrayList<ConfigHandlerBase>();
    protected int backButtonID;
    protected List<class_33> screenButtons = new ArrayList<class_33>();

    public ScreenBuilder(class_32 parent, ModContainer mod, ConfigCategoryHandler baseCategory) {
        this.parent = parent;
        this.mod = mod;
        this.baseCategory = baseCategory;
        this.configHandlerBases.addAll(baseCategory.values.values());
        this.configHandlerBases = this.configHandlerBases.stream().filter(value -> {
            if (value instanceof ConfigCategoryHandler) {
                return !value.parentField.getAnnotation(ConfigCategory.class).hidden();
            }
            if (value instanceof ConfigEntryHandler) {
                return !value.parentField.getAnnotation(ConfigEntry.class).hidden();
            }
            return false;
        }).collect(Collectors.toCollection(ArrayList::new));
        this.configHandlerBases.sort((self, other) -> {
            if (other instanceof ConfigCategoryHandler) {
                return 1;
            }
            return self instanceof ConfigCategoryHandler ? -1 : self.name.compareTo(other.name);
        });
    }

    public void method_119() {
        this.configHandlerBases.forEach(value -> {
            ConfigEntryHandler configEntry;
            if (value instanceof ConfigEntryHandler && (configEntry = (ConfigEntryHandler)value).getDrawableValue() != null) {
                configEntry.value = configEntry.getDrawableValue();
            }
        });
        this.field_154.clear();
        this.screenButtons.clear();
        this.scrollList = new ScreenScrollList();
        this.buttonToEntry = new HashMap();
        this.backButtonID = this.field_154.size();
        class_33 button = new class_33(this.backButtonID, this.field_152 / 2 - 75, this.field_153 - 26, 150, 20, class_300.method_992().method_993("gui.done"));
        this.field_154.add(button);
        this.screenButtons.add(button);
        this.configHandlerBases.forEach(value -> {
            if (value instanceof ConfigEntryHandler) {
                ConfigEntryHandler entryHandler = (ConfigEntryHandler)value;
                entryHandler.init(this, this.field_156);
            }
            value.getDrawables().forEach(val -> {
                if (val instanceof class_33) {
                    val.setID(this.field_154.size());
                    this.buttonToEntry.put(this.field_154.size(), (ConfigHandlerBase)value);
                    this.field_154.add(val);
                }
            });
        });
    }

    public void method_122() {
        super.method_122();
        this.configHandlerBases.forEach(value -> value.getDrawables().forEach(HasDrawable::tick));
    }

    protected void method_117(char character, int key) {
        super.method_117(character, key);
        this.configHandlerBases.forEach(value -> value.getDrawables().forEach(hasDrawable -> hasDrawable.keyPressed(character, key)));
    }

    public void method_118(int mouseX, int mouseY, float delta) {
        List<String> tooltip;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.scrollList.method_1256(mouseX, mouseY, delta);
        this.screenButtons.forEach(button -> button.method_1186(this.field_151, mouseX, mouseY));
        this.field_156.method_1903(this.baseCategory.name, this.field_152 / 2 - this.field_156.method_1901(this.baseCategory.name) / 2, 4, 0xFFFFFF);
        this.field_156.method_1903(this.baseCategory.description, this.field_152 / 2 - this.field_156.method_1901(this.baseCategory.description) / 2, 18, 0x808080);
        ArrayList drawables = new ArrayList();
        this.configHandlerBases.forEach(configHandlerBase -> drawables.addAll(configHandlerBase.getDrawables()));
        if (mouseY > 32 && mouseY < this.field_153 - 33 && (tooltip = ((ScreenAccessor)((Object)this)).glass_config_api$getMouseTooltip(mouseX, mouseY, drawables)) != null) {
            CharacterUtils.renderTooltip(this.field_156, tooltip, mouseX, mouseY, this);
        }
    }

    protected void method_124(int mouseX, int mouseY, int buttonID) {
        if (mouseY < 32 || mouseY > this.field_153 - 33) {
            for (class_33 button : this.screenButtons) {
                if (!button.method_1189(this.field_151, mouseX, mouseY)) continue;
                ((ScreenAccessor)((Object)this)).glass_config_api$setSelectedButton(button);
                this.field_151.field_2766.method_2009("random.click", 1.0f, 1.0f);
                this.method_120(button);
            }
            return;
        }
        if (buttonID != 0) {
            return;
        }
        for (Object buttonObj : this.field_154) {
            class_33 button = (class_33)buttonObj;
            if (!button.method_1189(this.field_151, mouseX, mouseY)) continue;
            ((ScreenAccessor)((Object)this)).glass_config_api$setSelectedButton(button);
            this.field_151.field_2766.method_2009("random.click", 1.0f, 1.0f);
            this.method_120(button);
        }
    }

    public void method_131() {
        super.method_131();
        float dWheel = Mouse.getDWheel();
        if (Mouse.isButtonDown((int)0) && this.mouseY > 32 && this.mouseY < this.field_153 - 33) {
            for (ConfigHandlerBase configHandlerBase : this.configHandlerBases) {
                configHandlerBase.getDrawables().forEach(val -> val.mouseClicked(this.mouseX, this.mouseY, 0));
            }
        } else if (dWheel != 0.0f) {
            this.scrollList.scroll(-(dWheel / 10.0f));
        }
    }

    protected void method_120(class_33 button) {
        if (button.field_1373 == this.backButtonID) {
            this.saveToEntries();
            this.field_151.method_2112(this.parent);
        } else if (this.mouseY >= 32 && this.mouseY <= this.field_153 - 33) {
            if (this.buttonToEntry.get(button.field_1373) instanceof ConfigEntryWithButton) {
                ((ConfigEntryWithButton)((Object)this.buttonToEntry.get(button.field_1373))).onClick();
            } else if (this.buttonToEntry.get(button.field_1373) instanceof ConfigCategoryHandler) {
                ((Minecraft)FabricLoader.getInstance().getGameInstance()).method_2112((class_32)((ConfigCategoryHandler)this.buttonToEntry.get(button.field_1373)).getConfigScreen(this, this.mod));
            }
        }
    }

    public void saveToEntries() {
        this.configHandlerBases.forEach(value -> {
            if (value instanceof ConfigEntryHandler) {
                ConfigEntryHandler configEntry = (ConfigEntryHandler)value;
                if (configEntry.isValueValid()) {
                    configEntry.value = configEntry.getDrawableValue();
                } else {
                    configEntry.setDrawableValue(configEntry.value);
                }
            }
        });
    }

    class ScreenScrollList
    extends class_97 {
        public ScreenScrollList() {
            super(ScreenBuilder.this.field_151, ScreenBuilder.this.field_152, ScreenBuilder.this.field_153, 32, ScreenBuilder.this.field_153 - 32, 48);
            this.method_1260(false);
        }

        public void scroll(float value) {
            EntryListWidgetAccessor baseAccessor = (EntryListWidgetAccessor)((Object)this);
            baseAccessor.setScrollAmount(baseAccessor.getScrollAmount() + value);
        }

        protected int method_1266() {
            return ScreenBuilder.this.configHandlerBases.size();
        }

        protected void method_1267(int entryIndex, boolean doLoad) {
            ScreenBuilder.this.selectedIndex = entryIndex;
        }

        protected boolean method_1270(int i) {
            return i == ScreenBuilder.this.selectedIndex;
        }

        protected void method_1269() {
            ScreenBuilder.this.method_134();
        }

        protected void method_1264(int itemId, int x, int y, int i1, class_67 arg) {
            ConfigHandlerBase configHandlerBase = ScreenBuilder.this.configHandlerBases.get(itemId);
            ScreenBuilder.this.method_1937(ScreenBuilder.this.field_156, configHandlerBase.name, x + 2, y + 1, 0xFFFFFF);
            configHandlerBase.getDrawables().forEach(val -> val.setXYWH(x + 2, y + 12, 212, 20));
            configHandlerBase.getDrawables().forEach(val -> val.draw(ScreenBuilder.this.mouseX, ScreenBuilder.this.mouseY));
            ScreenBuilder.this.method_1937(ScreenBuilder.this.field_156, configHandlerBase.description, x + 2, y + 34, 0x808080);
        }
    }
}

