package net.glasslauncher.mods.gcapi3.impl.screen;

import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.glasslauncher.mods.gcapi3.impl.ConfigRootEntry;
import net.glasslauncher.mods.gcapi3.impl.EventStorage;
import net.glasslauncher.mods.gcapi3.impl.GCCore;
import net.glasslauncher.mods.gcapi3.impl.object.ConfigCategoryHandler;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.client.Minecraft;
import java.util.*;

public class RootScreenBuilder extends ScreenBuilder {

    private final ArrayList<ConfigRootEntry> allRoots = new ArrayList<>();
    private final List<Integer> switchButtons = new ArrayList<>();
    public int currentIndex = 0;

    public RootScreenBuilder(class_32 parent, ModContainer mod, ConfigCategoryHandler baseCategory) {
        super(parent, mod, baseCategory);
        //noinspection deprecation
        GCCore.MOD_CONFIGS.forEach((key, value) -> {
            if (key.split(":")[0].equals(mod.getMetadata().getId())) {
                allRoots.add(value);
            }
        });

        allRoots.sort(Comparator.comparingInt(entry -> entry.configRoot().index()));
    }

    @Override
    public void method_119() {
        super.method_119();
        switchButtons.clear();
        if(allRoots.size() > 1) {
            int prevRoot = currentIndex - 1;
            if (prevRoot < 0) {
                prevRoot = allRoots.size()-1;
            }
            class_33 button = new class_33(field_154.size(), 2, 0, 160, 20, "< " + allRoots.get(prevRoot).configRoot().visibleName());
            //noinspection unchecked
            field_154.add(button);
            screenButtons.add(button);
            switchButtons.add(button.field_1373);

            int nextRoot = currentIndex + 1;
            if (nextRoot > allRoots.size()-1) {
                nextRoot = 0;
            }
            button = new class_33(field_154.size(), field_152 - 162, 0, 160, 20,  allRoots.get(nextRoot).configRoot().visibleName() + " >");
            //noinspection unchecked
            field_154.add(button);
            screenButtons.add(button);
            switchButtons.add(button.field_1373);
        }
    }

    @Override
    protected void method_120(class_33 button) {
        super.method_120(button);
        if (button.field_1373 == backButtonID) {
            //noinspection deprecation Intentional use of GCCore internals.
            GCCore.saveConfig(mod, baseCategory, EventStorage.EventSource.USER_SAVE);
        }
        if (switchButtons.contains(button.field_1373)) {
            int index = switchButtons.get(0) == button.field_1373? -1 : 1;
            index += currentIndex;
            if (index > allRoots.size()-1) {
                index = 0;
            }
            else if (index < 0) {
                index = allRoots.size()-1;
            }
            RootScreenBuilder builder = (RootScreenBuilder) allRoots.get(index).configCategoryHandler().getConfigScreen(parent, mod);
            builder.currentIndex = index;
            //noinspection deprecation
            ((Minecraft) FabricLoader.getInstance().getGameInstance()).method_2112(builder);
        }
    }
}
