/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.gcapi3.impl;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.glasslauncher.mods.gcapi3.api.PostConfigLoadedListener;
import net.glasslauncher.mods.gcapi3.api.PreConfigSavedListener;

public class EventStorage {
    public static final Map<String, EntrypointContainer<PreConfigSavedListener>> PRE_SAVE_LISTENERS = new HashMap<String, EntrypointContainer<PreConfigSavedListener>>();
    public static final Map<String, EntrypointContainer<PostConfigLoadedListener>> POST_LOAD_LISTENERS = new HashMap<String, EntrypointContainer<PostConfigLoadedListener>>();

    public static void loadListeners() {
        FabricLoader.getInstance().getEntrypointContainers("gcapi3:presave", PreConfigSavedListener.class).forEach(preConfigSavedListenerEntrypointContainer -> PRE_SAVE_LISTENERS.put(preConfigSavedListenerEntrypointContainer.getProvider().getMetadata().getId(), (EntrypointContainer<PreConfigSavedListener>)preConfigSavedListenerEntrypointContainer));
        FabricLoader.getInstance().getEntrypointContainers("gcapi3:postload", PostConfigLoadedListener.class).forEach(postConfigLoadedListenerEntrypointContainer -> POST_LOAD_LISTENERS.put(postConfigLoadedListenerEntrypointContainer.getProvider().getMetadata().getId(), (EntrypointContainer<PostConfigLoadedListener>)postConfigLoadedListenerEntrypointContainer));
    }

    public static class EventSource {
        public static final int UNKNOWN = 0;
        public static final int GAME_LOAD = 2;
        public static final int MODDED_SERVER_JOIN = 4;
        public static final int VANILLA_SERVER_JOIN = 8;
        public static final int SERVER_JOIN = 16;
        public static final int USER_SAVE = 32;
        public static final int MOD_SAVE = 64;
        public static final int SERVER_EXPORT = 128;

        public static boolean containsAll(int haystack, int ... needles) {
            int needlesBitwise = 0;
            for (int value : needles) {
                needlesBitwise |= value;
            }
            return (haystack & needlesBitwise) != 0;
        }

        public static boolean containsOne(int haystack, int ... needles) {
            for (int value : needles) {
                if ((haystack & value) == 0) continue;
                return true;
            }
            return false;
        }
    }
}

