package net.glasslauncher.mods.gcapi3.mixin.client;

import com.google.common.collect.ImmutableMap;
import io.github.prospector.modmenu.ModMenu;
import net.glasslauncher.mods.gcapi3.impl.GCCore;
import net.minecraft.class_32;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.*;
import java.util.function.*;

@Mixin(ModMenu.class)
public class ModMenuMixin {

    @Shadow private static Map<String, Function<class_32, ? extends class_32>> configScreenFactories;

    @Inject(method = "onInitializeClient", at = @At("TAIL"), remap = false)
    private void hijackConfigScreens(CallbackInfo ci) {
        //noinspection deprecation
        GCCore.log("Adding config screens to ModMenu...");
        Map<String, Function<class_32, ? extends class_32>> map = new HashMap<>();
        //noinspection deprecation
        GCCore.MOD_CONFIGS.forEach((key, value) -> {
            String namespace = key.split(":")[0];
            if (!map.containsKey(namespace)) {
                map.remove(namespace);
                map.put(namespace, (parent) -> value.configCategoryHandler().getConfigScreen(parent, value.modContainer()));
            }
        });
        configScreenFactories.putAll(map);
    }

}
