package net.glasslauncher.mods.gcapi3.impl.object.entry;

import com.google.common.collect.Iterables;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.glasslauncher.mods.gcapi3.api.CharacterUtils;
import net.glasslauncher.mods.gcapi3.api.ConfigEntry;
import net.glasslauncher.mods.gcapi3.api.ConfigEntryWithButton;
import net.glasslauncher.mods.gcapi3.api.HasDrawable;
import net.glasslauncher.mods.gcapi3.impl.object.ConfigEntryHandler;
import net.glasslauncher.mods.gcapi3.impl.screen.ScreenBuilder;
import net.glasslauncher.mods.gcapi3.impl.screen.widget.FancyButtonWidget;
import net.minecraft.class_300;
import net.minecraft.class_32;
import net.minecraft.class_34;
import org.jetbrains.annotations.NotNull;

import java.awt.*;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.List;

/**
 * This class is a bit of a crapshoot cause java's generic type handling is pitifully bad.
 * @param <T> The enum you want to use. Must have toString implemented. Also must be passed into the constructor.
 */
public class EnumConfigEntryHandler<T extends Enum<?>> extends ConfigEntryHandler<Integer> implements ConfigEntryWithButton {
    private FancyButtonWidget button;
    public final Enum<?>[] parentEnumArray;

    public EnumConfigEntryHandler(String id, ConfigEntry configEntry, Field parentField, Object parentObject, boolean multiplayerSynced, Integer value, Integer defaultValue, @SuppressWarnings("rawtypes") Class parentEnum) {
        super(id, configEntry, parentField, parentObject, multiplayerSynced, value, defaultValue);
        //noinspection unchecked Fuck off
        parentEnumArray = (Enum<?>[]) Iterables.toArray(EnumSet.allOf(parentEnum), parentEnum);
    }

    @Override
    public void init(class_32 parent, class_34 textRenderer) {
        super.init(parent, textRenderer);
        button = new FancyButtonWidget(10, 0, 0, 0, 0, getButtonText(), CharacterUtils.getIntFromColour(new Color(255, 202, 0, 255)));
        drawableList.add(button);
        button.field_1374 = !multiplayerLoaded;
    }

    @Override
    public Integer getDrawableValue() {
        return value;
    }

    @Override
    public void setDrawableValue(Integer value) {
        this.value = value;
        if(button != null) {
            button.field_1372 = getButtonText();
        }
    }

    @Override
    public boolean isValueValid() {
        return value < parentEnumArray.length;
    }

    @Override
    public @NotNull List<HasDrawable> getDrawables() {
        return drawableList;
    }

    @Environment(EnvType.CLIENT)
    @Override
    public void onClick() {
        value++;
        if(value > parentEnumArray.length - 1) {
            value = 0;
        }
        button.field_1372 = getButtonText();
        if (configEntry.requiresRestart()) {
            if (parent instanceof ScreenBuilder screenBuilder) {
                screenBuilder.setRequiresRestart();
            }
        }
    }

    @Override
    public void reset(Object defaultValue) throws IllegalAccessException {
        value = (Integer) defaultValue;
        setDrawableValue((Integer) defaultValue);
        saveToField();
    }

    @Override
    public void saveToField() throws IllegalAccessException {
        parentField.set(parentObject, parentEnumArray[value]);
    }

    public String getButtonText() {
        return class_300.method_992().method_993(parentEnumArray[value].toString()) + " (" + (value + 1) + "/" + parentEnumArray.length + ")";
    }
}
