package net.glasslauncher.mods.gcapi3.impl.screen.widget;

import net.glasslauncher.mods.gcapi3.api.HasToolTip;
import net.minecraft.class_33;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

import java.util.ArrayList;
import java.util.List;

/**
 * Copied from ModMenu
 */
public class TexturedButtonWidget extends class_33 implements HasToolTip {
	private final String texture;
	private final int u;
	private final int v;
	private final int uWidth;
	private final int vHeight;

	@SuppressWarnings("unused")
	public TexturedButtonWidget(int buttonId, int x, int y, int width, int height, int u, int v, String texture, int uWidth, int vHeight) {
		this(buttonId, x, y, width, height, u, v, texture, uWidth, vHeight, "");
	}

	public TexturedButtonWidget(int buttonId, int x, int y, int width, int height, int u, int v, String texture, int uWidth, int vHeight, String message) {
		super(buttonId, x, y, width, height, message);
		this.uWidth = uWidth;
		this.vHeight = vHeight;
		this.u = u;
		this.v = v;
		this.texture = texture;
	}

	public void setPos(int x, int y) {
		this.field_1370 = x;
		this.field_1371 = y;
	}

	protected boolean isHovered(int mouseX, int mouseY) {
		return mouseX >= this.field_1370 && mouseY >= this.field_1371 && mouseX < this.field_1370 + this.field_1368 && mouseY < this.field_1371 + this.field_1369;
	}

	@Override
	public void method_1186(Minecraft mc, int mouseX, int mouseY) {
		if (this.field_1375) {
			GL11.glBindTexture(GL11.GL_TEXTURE_2D, mc.field_2814.method_1100(texture));
			GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
			boolean hovered = isHovered(mouseX, mouseY);

			int adjustedV = this.v;
			if (!field_1374) {
				adjustedV += this.field_1369 * 2;
			} else if (hovered) {
				adjustedV += this.field_1369;
			}
			float uScale = 1f / uWidth;
			float vScale = 1f / vHeight;
			class_67 tess = class_67.field_2054;
			tess.method_1695();
			tess.method_1688(field_1370, field_1371 + field_1369, this.field_2522, (float) u * uScale, (float)(adjustedV + field_1369) * vScale);
			tess.method_1688(field_1370 + field_1368, field_1371 + field_1369, this.field_2522, ((float)(u + field_1368) * uScale), (float)(adjustedV + field_1369) * vScale);
			tess.method_1688(field_1370 + field_1368, field_1371, this.field_2522, (float)(u + field_1368) * uScale, (float)adjustedV * vScale);
			tess.method_1688(field_1370, field_1371, this.field_2522, (float) u * uScale, (float) adjustedV * vScale);
			tess.method_1685();

			this.method_1188(mc, mouseX, mouseY);
		}
	}

	@Override
	public List<String> getTooltip() {
		if (field_1372.isEmpty()) {
			return null;
		}
		else {
			return new ArrayList<>() {{
				add(field_1372);
			}};
		}
	}

	@Override
	public int[] getXYWH() {
		return new int[]{field_1370, field_1371, field_1368, field_1369};
	}
}
