/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.gcapi3.impl.object.entry;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import net.glasslauncher.mods.gcapi3.api.CharacterUtils;
import net.glasslauncher.mods.gcapi3.api.ConfigEntry;
import net.glasslauncher.mods.gcapi3.api.HasDrawable;
import net.glasslauncher.mods.gcapi3.impl.object.ConfigEntryHandler;
import net.glasslauncher.mods.gcapi3.impl.screen.ScreenBuilder;
import net.glasslauncher.mods.gcapi3.impl.screen.widget.ExtensibleTextFieldWidget;
import net.minecraft.class_32;
import net.minecraft.class_34;
import org.jetbrains.annotations.NotNull;

public class FloatConfigEntryHandler
extends ConfigEntryHandler<Float> {
    private ExtensibleTextFieldWidget textbox;

    public FloatConfigEntryHandler(String id, ConfigEntry configEntry, Field parentField, Object parentObject, boolean multiplayerSynced, Float value, Float defaultValue) {
        super(id, configEntry, parentField, parentObject, multiplayerSynced, value, defaultValue);
        this.textValidator = str -> FloatConfigEntryHandler.floatValidator(configEntry, str);
    }

    @Override
    public void init(class_32 parent, class_34 textRenderer) {
        super.init(parent, textRenderer);
        this.textbox = new ExtensibleTextFieldWidget(textRenderer);
        this.textbox.setValidator(this.textValidator);
        this.textbox.setMaxLength(String.valueOf(Float.MAX_VALUE).length());
        this.textbox.setText(((Float)this.value).toString());
        this.textbox.setEnabled(!this.multiplayerLoaded);
        this.textbox.setTextUpdatedListener(() -> {
            if (this.configEntry.requiresRestart() && parent instanceof ScreenBuilder) {
                ScreenBuilder screenBuilder = (ScreenBuilder)parent;
                screenBuilder.setRequiresRestart();
            }
        });
        this.drawableList.add(this.textbox);
    }

    @Override
    public Float getDrawableValue() {
        return this.textbox == null ? null : Float.valueOf(Float.parseFloat(this.textbox.getText()));
    }

    @Override
    public void setDrawableValue(Float value) {
        if (this.textbox == null) {
            return;
        }
        this.textbox.setText(value.toString());
    }

    @Override
    public boolean isValueValid() {
        return this.textValidator.apply(((Float)this.value).toString()) == null;
    }

    @Override
    @NotNull
    public List<HasDrawable> getDrawables() {
        return this.drawableList;
    }

    @Override
    public void reset(Object defaultValue) throws IllegalAccessException {
        this.value = (Float)defaultValue;
        this.setDrawableValue((Float)defaultValue);
        this.saveToField();
    }

    public static List<String> floatValidator(ConfigEntry configEntry, String str) {
        if (!CharacterUtils.isFloat(str)) {
            return Collections.singletonList("Value is not a floating point number");
        }
        if (Float.parseFloat(str) > (float)configEntry.maxLength()) {
            return Collections.singletonList("Value is too high");
        }
        if (Float.parseFloat(str) < (float)configEntry.minLength()) {
            return Collections.singletonList("Value is too low");
        }
        return null;
    }
}

