/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.gcapi3.impl.object.entry;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.gcapi3.api.ConfigEntry;
import net.glasslauncher.mods.gcapi3.api.ConfigEntryWithButton;
import net.glasslauncher.mods.gcapi3.api.HasDrawable;
import net.glasslauncher.mods.gcapi3.impl.object.ConfigEntryHandler;
import net.glasslauncher.mods.gcapi3.impl.screen.BaseListScreenBuilder;
import net.glasslauncher.mods.gcapi3.impl.screen.ScreenBuilder;
import net.glasslauncher.mods.gcapi3.impl.screen.widget.FancyButtonWidget;
import net.minecraft.class_32;
import net.minecraft.class_34;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;

public abstract class BaseListConfigEntryHandler<T>
extends ConfigEntryHandler<T[]>
implements ConfigEntryWithButton {
    @Environment(value=EnvType.CLIENT)
    private BaseListScreenBuilder<T> listScreen;
    @Environment(value=EnvType.CLIENT)
    private FancyButtonWidget button;
    protected Runnable textUpdatedListener = () -> {
        class_32 patt1248$temp;
        if (this.configEntry.requiresRestart() && (patt1248$temp = this.parent) instanceof ScreenBuilder) {
            ScreenBuilder screenBuilder = (ScreenBuilder)patt1248$temp;
            screenBuilder.setRequiresRestart();
        }
    };

    public BaseListConfigEntryHandler(String id, ConfigEntry configEntry, Field parentField, Object parentObject, boolean multiplayerSynced, T[] value, T[] defaultValue) {
        super(id, configEntry, parentField, parentObject, multiplayerSynced, value, defaultValue);
    }

    @Override
    public void init(class_32 parent, class_34 textRenderer) {
        super.init(parent, textRenderer);
        this.button = new FancyButtonWidget(10, 0, 0, 0, 0, "Open List... (" + ((Object[])this.value).length + " values)");
        this.drawableList.add(this.button);
        this.listScreen = this.createListScreen(parent);
        this.button.field_1374 = !this.multiplayerLoaded;
    }

    @Environment(value=EnvType.CLIENT)
    public abstract BaseListScreenBuilder<T> createListScreen(class_32 var1);

    public abstract T strToVal(String var1);

    @Override
    public T[] getDrawableValue() {
        if (this.listScreen == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        this.listScreen.textFieldWidgets.forEach(val -> {
            if (val.isValueValid()) {
                list.add(this.strToVal(val.getText()));
            }
        });
        return list.toArray(this.getTypedArray());
    }

    public abstract T[] getTypedArray();

    @Override
    public boolean isValueValid() {
        if ((long)((Object[])this.value).length > this.configEntry.maxArrayLength()) {
            return false;
        }
        if ((long)((Object[])this.value).length < this.configEntry.minArrayLength()) {
            return false;
        }
        return this.listContentsValid();
    }

    public boolean listContentsValid() {
        return Arrays.stream((Object[])this.value).noneMatch(aValue -> this.textValidator.apply(aValue.toString()) != null);
    }

    @Override
    public void setDrawableValue(T[] value) {
        this.listScreen.setValues(value);
    }

    @Override
    @NotNull
    public List<HasDrawable> getDrawables() {
        return this.drawableList;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void onClick() {
        ((Minecraft)FabricLoader.getInstance().getGameInstance()).method_2112(this.listScreen);
    }

    @Override
    public void reset(Object defaultValue) throws IllegalAccessException {
        this.value = ((Object[])defaultValue).clone();
        this.saveToField();
    }
}

