/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.gcapi3.impl.object.entry;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import net.glasslauncher.mods.gcapi3.api.CharacterUtils;
import net.glasslauncher.mods.gcapi3.api.ConfigEntry;
import net.glasslauncher.mods.gcapi3.api.HasDrawable;
import net.glasslauncher.mods.gcapi3.impl.object.ConfigEntryHandler;
import net.glasslauncher.mods.gcapi3.impl.screen.ScreenBuilder;
import net.glasslauncher.mods.gcapi3.impl.screen.widget.ExtensibleTextFieldWidget;
import net.minecraft.class_32;
import net.minecraft.class_34;
import org.jetbrains.annotations.NotNull;

public class DoubleConfigEntryHandler
extends ConfigEntryHandler<Double> {
    private ExtensibleTextFieldWidget textbox;

    public DoubleConfigEntryHandler(String id, ConfigEntry configEntry, Field parentField, Object parentObject, boolean multiplayerSynced, Double value, Double defaultValue) {
        super(id, configEntry, parentField, parentObject, multiplayerSynced, value, defaultValue);
        this.textValidator = str -> DoubleConfigEntryHandler.doubleValidator(configEntry, str);
    }

    @Override
    public void init(class_32 parent, class_34 textRenderer) {
        super.init(parent, textRenderer);
        this.textbox = new ExtensibleTextFieldWidget(textRenderer);
        this.textbox.setValidator(this.textValidator);
        this.textbox.setMaxLength(String.valueOf(Integer.MAX_VALUE).length());
        this.textbox.setText(((Double)this.value).toString());
        this.textbox.setEnabled(!this.multiplayerLoaded);
        this.textbox.setTextUpdatedListener(() -> {
            if (this.configEntry.requiresRestart() && parent instanceof ScreenBuilder) {
                ScreenBuilder screenBuilder = (ScreenBuilder)parent;
                screenBuilder.setRequiresRestart();
            }
        });
        this.drawableList.add(this.textbox);
    }

    @Override
    public Double getDrawableValue() {
        return this.textbox == null ? null : Double.valueOf(Double.parseDouble(this.textbox.getText()));
    }

    @Override
    public void setDrawableValue(Double value) {
        if (this.textbox == null) {
            return;
        }
        this.textbox.setText(value.toString());
    }

    @Override
    public boolean isValueValid() {
        return this.textValidator.apply(((Double)this.value).toString()) == null;
    }

    @Override
    @NotNull
    public List<HasDrawable> getDrawables() {
        return this.drawableList;
    }

    @Override
    public void reset(Object defaultValue) throws IllegalAccessException {
        this.value = (Double)defaultValue;
        this.setDrawableValue((Double)defaultValue);
        this.saveToField();
    }

    public static List<String> doubleValidator(ConfigEntry configEntry, String str) {
        if (!CharacterUtils.isFloat(str)) {
            return Collections.singletonList("Value is not a whole number");
        }
        double d = Double.parseDouble(str);
        double d2 = configEntry.maxValue() == 32.0 ? (double)configEntry.maxLength() : configEntry.maxValue();
        if (d > (double)Math.round(d2)) {
            return Collections.singletonList("Value is too high");
        }
        double d3 = Double.parseDouble(str);
        double d4 = configEntry.minValue() == 0.0 ? (double)configEntry.minLength() : configEntry.minValue();
        if (d3 < d4) {
            return Collections.singletonList("Value is too low");
        }
        return null;
    }
}

