/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.gcapi3.impl.screen;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.glasslauncher.mods.gcapi3.impl.ConfigRootEntry;
import net.glasslauncher.mods.gcapi3.impl.GCCore;
import net.glasslauncher.mods.gcapi3.impl.object.ConfigCategoryHandler;
import net.glasslauncher.mods.gcapi3.impl.screen.RestartWantedScreen;
import net.glasslauncher.mods.gcapi3.impl.screen.ScreenBuilder;
import net.glasslauncher.mods.gcapi3.mixin.client.MinecraftAccessor;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.client.Minecraft;

public class RootScreenBuilder
extends ScreenBuilder {
    private final ArrayList<ConfigRootEntry> allRoots = new ArrayList();
    private final List<Integer> switchButtons = new ArrayList<Integer>();
    public int currentIndex = 0;

    public RootScreenBuilder(class_32 parent, ModContainer mod, ConfigCategoryHandler baseCategory) {
        super(parent, mod, baseCategory);
        GCCore.MOD_CONFIGS.forEach((key, value) -> {
            if (key.split(":")[0].equals(mod.getMetadata().getId())) {
                this.allRoots.add((ConfigRootEntry)value);
            }
        });
        this.allRoots.sort(Comparator.comparingInt(entry -> entry.configRoot().index()));
    }

    @Override
    public void method_119() {
        super.method_119();
        this.switchButtons.clear();
        if (this.allRoots.size() > 1) {
            int prevRoot = this.currentIndex - 1;
            if (prevRoot < 0) {
                prevRoot = this.allRoots.size() - 1;
            }
            class_33 button = new class_33(this.field_154.size(), 2, 0, 160, 20, "< " + this.allRoots.get(prevRoot).configRoot().visibleName());
            this.field_154.add(button);
            this.screenButtons.add(button);
            this.switchButtons.add(button.field_1373);
            int nextRoot = this.currentIndex + 1;
            if (nextRoot > this.allRoots.size() - 1) {
                nextRoot = 0;
            }
            button = new class_33(this.field_154.size(), this.field_152 - 162, 0, 160, 20, this.allRoots.get(nextRoot).configRoot().visibleName() + " >");
            this.field_154.add(button);
            this.screenButtons.add(button);
            this.switchButtons.add(button.field_1373);
        }
    }

    @Override
    public void setRequiresRestart() {
        super.setRequiresRestart();
        GCCore.RELOAD_WANTED = true;
    }

    @Override
    protected void method_120(class_33 button) {
        super.method_120(button);
        if (button.field_1373 == this.backButtonID) {
            GCCore.saveConfig(this.mod, this.baseCategory, 32);
            if (GCCore.RELOAD_WANTED) {
                MinecraftAccessor.getInstance().method_2112((class_32)new RestartWantedScreen(this));
            }
        }
        if (this.switchButtons.contains(button.field_1373)) {
            int index;
            int n = index = this.switchButtons.get(0) == button.field_1373 ? -1 : 1;
            if ((index += this.currentIndex) > this.allRoots.size() - 1) {
                index = 0;
            } else if (index < 0) {
                index = this.allRoots.size() - 1;
            }
            RootScreenBuilder builder = (RootScreenBuilder)this.allRoots.get(index).configCategoryHandler().getConfigScreen(this.parent, this.mod);
            builder.currentIndex = index;
            ((Minecraft)FabricLoader.getInstance().getGameInstance()).method_2112((class_32)builder);
        }
    }
}

